/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.utilities;

import java.io.Serializable;

public class MathUtil {
    public static double angleBetween(float[] v, float[] u) {
        Vector3D vv = new Vector3D(v[0], v[1], v[2]);
        Vector3D uu = new Vector3D(u[0], u[1], u[2]);
        return Math.toDegrees(vv.angleWith(uu));
    }

    public static class Vector3D
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double x;
        public double y;
        public double z;

        public Vector3D(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public double dotProduct(Vector3D other) {
            return this.x * other.x + this.y * other.y + this.z * other.z;
        }

        public double magnitude() {
            return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        public double angleWith(Vector3D other) {
            double dotProduct = this.dotProduct(other);
            double magnitudeProduct = this.magnitude() * other.magnitude();
            double cosine = dotProduct / magnitudeProduct;
            return Math.acos(cosine);
        }

        public static Vector3D lerp(Vector3D a, Vector3D b, double t) {
            return new Vector3D(a.x + (b.x - a.x) * t, a.y + (b.y - a.y) * t, a.z + (b.z - a.z) * t);
        }

        public static Vector3D rotate(Vector3D v, Vector3D rot) {
            Vector3D result = new Vector3D(v.x, v.y, v.z);
            double cosX = Math.cos(rot.x);
            double sinX = Math.sin(rot.x);
            double y = result.y * cosX - result.z * sinX;
            double z = result.y * sinX + result.z * cosX;
            result.y = y;
            result.z = z;
            double cosY = Math.cos(rot.y);
            double sinY = Math.sin(rot.y);
            double x = result.x * cosY + result.z * sinY;
            z = -result.x * sinY + result.z * cosY;
            result.x = x;
            result.z = z;
            double cosZ = Math.cos(rot.z);
            double sinZ = Math.sin(rot.z);
            x = result.x * cosZ - result.y * sinZ;
            y = result.x * sinZ + result.y * cosZ;
            result.x = x;
            result.y = y;
            return result;
        }

        public static Vector3D add(Vector3D a, Vector3D b) {
            return new Vector3D(a.x + b.x, a.y + b.y, a.z + b.z);
        }

        public static Vector3D multiply(Vector3D v, double scalar) {
            return new Vector3D(v.x * scalar, v.y * scalar, v.z * scalar);
        }
    }
}

