/*
 * Decompiled with CFR 0.152.
 */
package com.crashstudios.crashcore.utilities;

import com.crashstudios.crashcore.folia.CrashScheduler;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TPS {
    private static long lastTimeMillis = 0L;
    private static double currentTps = 20.0;
    private static int sampleTicks;

    public static void init(JavaPlugin pluginInstance, int sampleTicks) {
        TPS.sampleTicks = Math.max(1, sampleTicks);
        lastTimeMillis = System.currentTimeMillis();
        CrashScheduler.runTaskTimer((Plugin)pluginInstance, TPS::sample, (long)sampleTicks, (long)sampleTicks);
    }

    private static void sample() {
        long now = System.currentTimeMillis();
        double elapsedSec = (double)(now - lastTimeMillis) / 1000.0;
        if (elapsedSec <= 0.0) {
            return;
        }
        long ticksPassed = sampleTicks;
        currentTps = Math.min(20.0, (double)ticksPassed / elapsedSec);
        lastTimeMillis = now;
    }

    public static double getTPS() {
        return currentTps;
    }
}

