/*
 * Decompiled with CFR 0.152.
 */
package com.dinus.easyserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EasyServer
extends JavaPlugin
implements Listener,
TabCompleter {
    public void onEnable() {
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("message").setExecutor((CommandExecutor)this);
        this.getCommand("message").setTabCompleter((TabCompleter)this);
        this.getLogger().info("EasyServer has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("EasyServer has been disabled!");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.getConfig().getBoolean("enabled.join", true)) {
            String message = this.getConfig().getString("messages.join", "{player} joined the game");
            event.setJoinMessage(this.formatMessage(message, event.getPlayer()));
        } else {
            event.setJoinMessage(null);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.getConfig().getBoolean("enabled.quit", true)) {
            String message = this.getConfig().getString("messages.quit", "{player} left the game");
            event.setQuitMessage(this.formatMessage(message, event.getPlayer()));
        } else {
            event.setQuitMessage(null);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (this.getConfig().getBoolean("enabled.death", true)) {
            String deathCause = event.getDeathMessage() != null ? event.getDeathMessage() : "unknown cause";
            String message = this.getConfig().getString("messages.death", "{cause}");
            message = message.replace("{cause}", deathCause);
            event.setDeathMessage(this.formatMessage(message, event.getEntity()));
        } else {
            event.setDeathMessage(null);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("easyserver.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "set": {
                if (args.length < 3) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /message set <join|quit|death> <message>");
                    return true;
                }
                this.handleSet(sender, args);
                break;
            }
            case "enable": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /message enable <join|quit|death>");
                    return true;
                }
                this.handleToggle(sender, args[1], true);
                break;
            }
            case "disable": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /message disable <join|quit|death>");
                    return true;
                }
                this.handleToggle(sender, args[1], false);
                break;
            }
            case "reload": {
                this.reloadConfig();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration reloaded!");
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String[] commands;
            for (String cmd : commands = new String[]{"set", "enable", "disable", "reload"}) {
                if (!cmd.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                completions.add(cmd);
            }
            return completions;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("enable") || args[0].equalsIgnoreCase("disable")) {
                completions.addAll(Arrays.asList("join", "quit", "death"));
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("set")) {
            String type;
            switch (type = args[1].toLowerCase()) {
                case "join": {
                    completions.add("{player}_joined_the_game");
                    break;
                }
                case "quit": {
                    completions.add("{player}_left_the_game");
                    break;
                }
                case "death": {
                    completions.add("{cause}");
                }
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        String input = args[args.length - 1].toLowerCase();
        for (String completion : completions) {
            if (!completion.toLowerCase().startsWith(input)) continue;
            result.add(completion);
        }
        return result;
    }

    private void handleSet(CommandSender sender, String[] args) {
        String type = args[1].toLowerCase();
        if (!(type.equals("join") || type.equals("quit") || type.equals("death"))) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid type! Please use: join, quit, or death");
            return;
        }
        StringBuilder messageBuilder = new StringBuilder();
        for (int i = 2; i < args.length; ++i) {
            messageBuilder.append(args[i]);
            if (i >= args.length - 1) continue;
            messageBuilder.append(" ");
        }
        String message = messageBuilder.toString();
        this.getConfig().set("messages." + type, (Object)message);
        this.saveConfig();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + type + " message has been set!");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Preview: " + ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    private void handleToggle(CommandSender sender, String type, boolean enabled) {
        if (!(type.equals("join") || type.equals("quit") || type.equals("death"))) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid type! Please use: join, quit, or death");
            return;
        }
        this.getConfig().set("enabled." + type, (Object)enabled);
        this.saveConfig();
        String status = enabled ? String.valueOf(ChatColor.GREEN) + "enabled" : String.valueOf(ChatColor.RED) + "disabled";
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + type + " message has been " + status + String.valueOf(ChatColor.YELLOW) + "!");
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== EasyServer Commands ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/message set <join|quit|death> <message>" + String.valueOf(ChatColor.WHITE) + " - Set message");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/message enable <join|quit|death>" + String.valueOf(ChatColor.WHITE) + " - Enable message");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/message disable <join|quit|death>" + String.valueOf(ChatColor.WHITE) + " - Disable message");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/message reload" + String.valueOf(ChatColor.WHITE) + " - Reload config");
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "============================");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Tip: Use & for color codes!");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Example: /message set join &a{player} &fwelcome!");
    }

    private String formatMessage(String message, Player player) {
        message = message.replace("{player}", player.getName());
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }
}

