/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.config;

import dex.autoswitch.config.AutoSwitchConfig;
import dex.autoswitch.config.ConfigHandler;
import dex.lib.org.spongepowered.configurate.CommentedConfigurationNode;
import dex.lib.org.spongepowered.configurate.ConfigurateException;
import dex.lib.org.spongepowered.configurate.ConfigurationNode;
import dex.lib.org.spongepowered.configurate.NodePath;
import dex.lib.org.spongepowered.configurate.reactive.Subscriber;
import dex.lib.org.spongepowered.configurate.reference.ConfigurationReference;
import dex.lib.org.spongepowered.configurate.reference.ValueReference;
import dex.lib.org.spongepowered.configurate.reference.WatchServiceListener;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class AutoSwitchConfigReference {
    private static final Logger LOGGER = Logger.getLogger("AutoSwitch Config");
    private final Path path;
    private final WatchServiceListener listener;
    private final ConfigurationReference<@NotNull CommentedConfigurationNode> base;
    private final ValueReference<AutoSwitchConfig, @NotNull CommentedConfigurationNode> config;

    public AutoSwitchConfigReference(Path path, URL defaultConfig) throws IOException {
        this.path = path;
        this.listener = WatchServiceListener.create();
        this.base = this.listener.listenToConfiguration(ConfigHandler::createLoader, path);
        this.base.updates().subscribe($ -> LOGGER.info("Configuration automatically reloaded"));
        this.base.errors().subscribe(e -> {
            Throwable thr = (Throwable)e.getValue();
            LOGGER.severe("Encountered error reading config, using current values or defaults!");
            LOGGER.severe("Unable to " + String.valueOf(e.getKey()) + " the configuration: " + thr.getMessage());
            if (thr.getCause() != null) {
                LOGGER.log(Level.SEVERE, "Cause", thr);
            }
        });
        this.base.get(new Object[0]).mergeFrom((ConfigurationNode)ConfigHandler.createLoader(defaultConfig).load());
        this.config = this.base.referenceTo(AutoSwitchConfig.class, NodePath.path(), new AutoSwitchConfig());
        this.base.save();
    }

    public AutoSwitchConfig config() {
        return this.config.get();
    }

    public void addListener(Subscriber<AutoSwitchConfig> subscriber) {
        this.config.subscribe(subscriber);
    }

    public void updateConfig(Function<AutoSwitchConfig, AutoSwitchConfig> function) throws ConfigurateException {
        this.config.update(function);
        this.base.save();
    }

    public void save() throws ConfigurateException {
        this.base.save();
    }
}

