/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.config.subentries;

import dex.autoswitch.config.data.tree.ExpressionTree;
import dex.autoswitch.engine.Action;
import dex.autoswitch.engine.TargetType;
import dex.lib.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import dex.lib.org.spongepowered.configurate.objectmapping.meta.Comment;
import java.util.HashSet;
import java.util.Set;

@ConfigSerializable
public class FeatureConfig {
    @Comment(value="Switch away from the currently active tool when no tools matched for the current target.\nE.g. you are holding a shovel but attack stone and have no pickaxe, if this is enabled\nit will switch off of the shovel to some non-tool item.\nOnly triggers for the actions specified.")
    public Set<Action> switchAwayFromTools = Set.of(Action.ATTACK);
    @Comment(value="\"Prefer the tool with minimum required mining level.")
    public boolean preferMinimumViableTool = true;
    public Set<TargetType> switchAllowed = Set.of(TargetType.values());
    @Comment(value="Return to the previous slot when no longer performing the action on the specified type. Leave blank to disable this behavior entirely.")
    public Set<TargetType> switchBackAllowed = Set.of(TargetType.BLOCKS, TargetType.ENTITIES);
    @Comment(value="Which actions to perform switching for.")
    public Set<Action> switchActions = Set.of(Action.values());
    @Comment(value="Disable switching when crouching.")
    public boolean disableWhenCrouched = false;
    @Comment(value="Disable switching on startup.")
    public boolean disableOnStartup = false;
    @Comment(value="Don't switch tools in creative mode.")
    public boolean switchInCreative = false;
    @Comment(value="Switch in multiplayer.")
    public boolean switchInMp = true;
    @Comment(value="Controls where and if the keybinding toggle message should be displayed. DEFAULT is above the hotbar, like with bed messages. CHAT is in the chat bar, like a normal chat message. Set to OFF to disable the message entirely.")
    public DisplayControl toggleMessageControl = DisplayControl.DEFAULT;
    @Comment(value="Prevents switching for 'attack' action on a block for the specified number of ticks after attacking an entity.")
    public int preventBlockSwitchAfterEntityAttack = 5;
    @Comment(value="Delay in ticks from end of hand swinging to perform switchback action.")
    public int switchbackDelay = 1;
    @Comment(value="Delay switchback until attack progress has fully charged when these targets match.\nThis is useful when fighting mobs, where otherwise after each attack switchback will trigger,\ncausing the attack progress to reset.\n")
    public Set<SwitchbackSelector> switchbackWaitsForAttackProgress = new HashSet<SwitchbackSelector>();
    @Comment(value="Determine when to swap a tool to the offhand when interacting.")
    public Set<OffhandSelector> offhandSelectors = new HashSet<OffhandSelector>();
    @Comment(value="If true, skip tools that are out of energy or durability.")
    public boolean skipDepletedItems = true;

    public static enum DisplayControl {
        DEFAULT(true),
        CHAT(true),
        OFF(false);

        private final boolean allowed;

        private DisplayControl(boolean allowed1) {
            this.allowed = allowed1;
        }

        public boolean allowed() {
            return this.allowed;
        }
    }

    @ConfigSerializable
    public static class SwitchbackSelector {
        public Action action;
        public ExpressionTree target;

        public String toString() {
            return "SwitchbackSelector{action=" + String.valueOf((Object)this.action) + ", target=" + String.valueOf(this.target) + "}";
        }
    }

    @ConfigSerializable
    public static class OffhandSelector {
        public int priority = 10;
        public TargetType type;
        public ExpressionTree tool;

        public String toString() {
            return "OffhandSelector{priority=" + this.priority + ", type=" + String.valueOf((Object)this.type) + ", tool=" + String.valueOf(this.tool) + "}";
        }
    }
}

