/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine;

import dex.autoswitch.config.data.tree.Data;
import dex.autoswitch.config.data.tree.DataMap;
import dex.autoswitch.config.data.tree.DisjunctiveUnion;
import dex.autoswitch.config.data.tree.ExpressionTree;
import dex.autoswitch.config.data.tree.IdSelector;
import dex.autoswitch.config.data.tree.Intersection;
import dex.autoswitch.config.data.tree.Invert;
import dex.autoswitch.config.data.tree.TypedData;
import dex.autoswitch.config.data.tree.Union;
import dex.autoswitch.engine.data.Match;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.futures.FutureSelectable;
import dex.autoswitch.futures.FutureSelectableGroup;
import dex.autoswitch.futures.FutureSelectableValue;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface Matcher {
    public Match matches(int var1, SelectionContext var2, Object var3);

    public static String prettyPrint(Matcher matcher) {
        return Matcher.prettyPrint(matcher, 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String prettyPrint(Matcher matcher, int level) {
        Object object;
        Matcher matcher2 = matcher;
        Objects.requireNonNull(matcher2);
        Matcher matcher3 = matcher2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DisjunctiveUnion.class, Intersection.class, Union.class, Invert.class, IdSelector.class, TypedData.class}, (Object)matcher3, n)) {
            case 0: {
                Set<ExpressionTree> children;
                DisjunctiveUnion disjunctiveUnion = (DisjunctiveUnion)matcher3;
                try {
                    Set<ExpressionTree> set;
                    children = set = disjunctiveUnion.children();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                object = Matcher.prettyPrintChildren("XOR", children, level);
                return object;
            }
            case 1: {
                Set<ExpressionTree> children;
                Intersection intersection = (Intersection)matcher3;
                {
                    Set<ExpressionTree> set;
                    children = set = intersection.children();
                }
                object = Matcher.prettyPrintChildren("OR", children, level);
                return object;
            }
            case 2: {
                Set<ExpressionTree> children;
                Union union = (Union)matcher3;
                {
                    Set<ExpressionTree> set;
                    children = set = union.children();
                }
                object = Matcher.prettyPrintChildren("AND", children, level);
                return object;
            }
            case 3: {
                ExpressionTree child;
                Invert invert = (Invert)matcher3;
                {
                    ExpressionTree expressionTree;
                    child = expressionTree = invert.child();
                }
                object = " ".repeat(level) + "NOT[" + Matcher.prettyPrint(child, level + 1) + "]";
                return object;
            }
            case 4: {
                StringBuilder sb;
                Object data;
                FutureSelectable<?, ?> selectable;
                IdSelector idSelector = (IdSelector)matcher3;
                {
                    Object object2 = idSelector.selectable();
                    selectable = object2;
                    data = object2 = idSelector.data();
                    sb = new StringBuilder(selectable.getSelectorType().id());
                    sb.append('[');
                }
                FutureSelectable<?, ?> futureSelectable = selectable;
                Objects.requireNonNull(futureSelectable);
                FutureSelectable<?, ?> futureSelectable2 = futureSelectable;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FutureSelectableGroup.class, FutureSelectableValue.class}, futureSelectable2, n2)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        FutureSelectableGroup v = (FutureSelectableGroup)futureSelectable2;
                        sb.append('#').append(v.getKey());
                        break;
                    }
                    case 1: {
                        FutureSelectableValue v = (FutureSelectableValue)futureSelectable2;
                        sb.append(v.getKey());
                    }
                }
                sb.append(']');
                String indent = " ".repeat(level);
                Iterator iterator = data.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        object = indent + String.valueOf(sb);
                        return object;
                    }
                    TypedData subDatum = (TypedData)iterator.next();
                    sb.append('\n').append(indent);
                    sb.append(Matcher.prettyPrint(subDatum, level + 1));
                }
            }
            case 5: {
                TypedData typedData = (TypedData)matcher3;
                object = " ".repeat(level) + typedData.type().id() + "[" + Matcher.prettyPrint(typedData.data(), level + 1) + "]";
                return object;
            }
        }
        object = " ".repeat(level) + "<Fallback>";
        return object;
    }

    @NotNull
    private static String prettyPrintChildren(String type, Set<ExpressionTree> children, int level) {
        String indent = " ".repeat(Math.max(0, level - 1));
        return type + "{\n" + children.stream().map(child -> Matcher.prettyPrint(child, level + 1)).collect(Collectors.joining("\n")) + "\n" + indent + "}";
    }

    private static String prettyPrint(Data data, int level) {
        Data data2 = data;
        Objects.requireNonNull(data2);
        Data data3 = data2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataMap.Pair.class, DataMap.Value.class, DataMap.Map.class, ExpressionTree.class}, (Object)data3, n)) {
            case 0 -> {
                DataMap.Pair pair = (DataMap.Pair)data3;
                yield pair.key() + ": " + Matcher.prettyPrint(pair.value(), level);
            }
            case 1 -> {
                DataMap.Value value = (DataMap.Value)data3;
                yield value.value();
            }
            case 2 -> {
                DataMap.Map map = (DataMap.Map)data3;
                yield map.entries().stream().map(entry -> Matcher.prettyPrint(entry, level)).collect(Collectors.joining("\n" + " ".repeat(level)));
            }
            case 3 -> {
                ExpressionTree tree = (ExpressionTree)data3;
                yield Matcher.prettyPrint(tree, level);
            }
            default -> data.toString();
        };
    }
}

