/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.types.selectable;

import dex.autoswitch.Constants;
import dex.autoswitch.api.impl.AutoSwitchApi;
import dex.autoswitch.engine.Action;
import dex.autoswitch.engine.TargetType;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.types.selectable.SelectableResource;
import dex.autoswitch.futures.FutureSelectable;
import dex.autoswitch.platform.Services;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.Nullable;

public class ItemSelectableType
extends SelectableResource<class_1792> {
    public static final ItemSelectableType INSTANCE = new ItemSelectableType();

    public ItemSelectableType() {
        super("item");
    }

    @Override
    public class_6880<class_1792> lookup(class_2960 resourceLocation) {
        return class_7923.field_41178.method_10223(resourceLocation).orElse(null);
    }

    @Override
    public class_6862<class_1792> lookupGroup(class_2960 resourceLocation) {
        return class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)resourceLocation);
    }

    @Override
    public boolean matches(SelectionContext context, class_6880<class_1792> v, Object selectable) {
        class_1792 item;
        class_2680 state;
        Object object;
        class_1792 ref = (class_1792)v.comp_349();
        if (selectable instanceof class_1799) {
            class_1799 stack = (class_1799)selectable;
            if (Constants.CONFIG.featureConfig.skipDepletedItems) {
                for (Predicate<class_1799> stackPredicate : AutoSwitchApi.INSTANCE.DEPLETED) {
                    if (!stackPredicate.test(stack)) continue;
                    return false;
                }
            }
            if (ref.equals(stack.method_7909())) {
                object = context.target();
                if (object instanceof class_2680) {
                    state = (class_2680)object;
                    return this.isCorrectTool(stack, state);
                }
                return true;
            }
        }
        if (selectable instanceof class_1792 && ref.equals(item = (class_1792)selectable)) {
            object = context.target();
            if (object instanceof class_2680) {
                state = (class_2680)object;
                return this.isCorrectTool(item, state);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesGroup(SelectionContext context, class_6862<class_1792> itemTagKey, Object selectable) {
        class_1792 item;
        class_2680 state;
        Object object;
        if (selectable instanceof class_1799) {
            class_1799 stack = (class_1799)selectable;
            if (Constants.CONFIG.featureConfig.skipDepletedItems) {
                for (Predicate<class_1799> stackPredicate : AutoSwitchApi.INSTANCE.DEPLETED) {
                    if (!stackPredicate.test(stack)) continue;
                    return false;
                }
            }
            if (Services.PLATFORM.isInTag(itemTagKey, stack.method_7909())) {
                object = context.target();
                if (object instanceof class_2680) {
                    state = (class_2680)object;
                    return this.isCorrectTool(stack, state);
                }
                return true;
            }
        }
        if (selectable instanceof class_1792 && Services.PLATFORM.isInTag(itemTagKey, item = (class_1792)selectable)) {
            object = context.target();
            if (object instanceof class_2680) {
                state = (class_2680)object;
                return this.isCorrectTool(item, state);
            }
            return true;
        }
        return false;
    }

    private boolean isCorrectTool(class_1799 stack, class_2680 state) {
        return !state.method_29291() || stack.method_7951(state);
    }

    private boolean isCorrectTool(class_1792 item, class_2680 state) {
        class_9424 tool = (class_9424)item.method_57347().method_58694(class_9334.field_50077);
        if (!state.method_29291()) {
            return true;
        }
        return tool != null && tool.method_58426(state);
    }

    @Override
    @Nullable
    public TargetType targetType() {
        return null;
    }

    @Override
    public boolean isOf(Object o) {
        class_6880 h;
        return o instanceof class_1799 || o instanceof class_1792 || o instanceof class_6880 && (h = (class_6880)o).comp_349() instanceof class_1792;
    }

    @Override
    public double typeRating(SelectionContext context, FutureSelectable<class_2960, class_6880<class_1792>> futureValue, Object selectable) {
        if (context.action() != Action.ATTACK) {
            if (selectable instanceof class_1799) {
                class_1799 stack = (class_1799)selectable;
                if (stack.method_7963()) {
                    if (stack.method_7936() > 0) {
                        return (double)stack.method_7919() / (double)stack.method_7936();
                    }
                } else if (stack.method_7946()) {
                    return (double)stack.method_7947() / (double)stack.method_7914();
                }
            }
            return 0.0;
        }
        if (selectable instanceof class_1799) {
            Object tool;
            class_1799 stack = (class_1799)selectable;
            Object object = context.target();
            if (object instanceof class_2680) {
                class_2680 state = (class_2680)object;
                tool = (class_9424)stack.method_58694(class_9334.field_50077);
                double defaultSpeed = 1.0;
                if (tool != null) {
                    defaultSpeed = tool.comp_2499();
                }
                double normSpeed = ((double)stack.method_7924(state) - defaultSpeed) / defaultSpeed;
                if (Constants.CONFIG.featureConfig.preferMinimumViableTool) {
                    normSpeed = 1.0 - normSpeed;
                }
                return normSpeed;
            }
            tool = context.target();
            if (tool instanceof class_1297) {
                class_1297 entity = (class_1297)tool;
                MutableDouble damage = new MutableDouble(1.0);
                MutableDouble speed = new MutableDouble(4.0);
                stack.method_57354(class_1304.field_6173, (attributeHolder, attributeModifier) -> {
                    double d0;
                    double d1;
                    int baseValue;
                    if (attributeHolder.method_55838(class_5134.field_23721)) {
                        baseValue = 1;
                        d1 = attributeModifier.comp_2449();
                        d0 = damage.doubleValue();
                        damage.setValue(d0 += (switch (attributeModifier.comp_2450()) {
                            default -> throw new MatchException(null, null);
                            case class_1322.class_1323.field_6328 -> d1;
                            case class_1322.class_1323.field_6330 -> d1 * (double)baseValue;
                            case class_1322.class_1323.field_6331 -> d1 * d0;
                        }));
                    }
                    if (attributeHolder.method_55838(class_5134.field_23723)) {
                        baseValue = 4;
                        d1 = attributeModifier.comp_2449();
                        d0 = speed.doubleValue();
                        speed.setValue(d0 += (switch (attributeModifier.comp_2450()) {
                            default -> throw new MatchException(null, null);
                            case class_1322.class_1323.field_6328 -> d1;
                            case class_1322.class_1323.field_6330 -> d1 * (double)baseValue;
                            case class_1322.class_1323.field_6331 -> d1 * d0;
                        }));
                    }
                });
                if (speed.doubleValue() == 0.0 || damage.doubleValue() == 0.0) {
                    return 0.0;
                }
                return damage.doubleValue() * speed.doubleValue();
            }
        }
        return 0.0;
    }

    private static float clampMiningSpeed(float original) {
        if (original > 0.0f) {
            return (float)(6.25 * Math.log10(original) / (double)original);
        }
        return original;
    }
}

