/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch;

import com.mojang.blaze3d.platform.InputConstants;
import dex.autoswitch.CommonClass;
import dex.autoswitch.Constants;
import dex.autoswitch.api.impl.AutoSwitchApi;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.energy.IEnergyStorage;

@Mod(value="autoswitch", dist={Dist.CLIENT})
public class Autoswitch {
    public static final Lazy<KeyMapping> SWITCH_TOGGLE = Lazy.of(() -> new KeyMapping("key.autoswitch.toggle", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 82, "key.categories.autoswitch"));

    public Autoswitch(IEventBus eventBus) {
        CommonClass.init();
        NeoForge.EVENT_BUS.addListener(Autoswitch::onTick);
        eventBus.addListener(Autoswitch::registerBindings);
        eventBus.addListener(Autoswitch::sendIMC);
        eventBus.addListener(Autoswitch::receiveIMC);
        Constants.LOG.info("AutoSwitch Neoforge Loaded!");
    }

    private static void sendIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"autoswitch", (String)AutoSwitchApi.INSTANCE.DEPLETED.id().getPath(), () -> stack -> {
            IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (cap != null) {
                return cap.getEnergyStored() == 0;
            }
            return false;
        });
        InterModComms.sendTo((String)"autoswitch", (String)AutoSwitchApi.INSTANCE.DEPLETED.id().getPath(), () -> stack -> {
            if (stack.isDamageableItem()) {
                return stack.nextDamageWillBreak();
            }
            return false;
        });
    }

    private static void receiveIMC(InterModProcessEvent event) {
        InterModComms.getMessages((String)"autoswitch").forEach(imc -> {
            Constants.LOG.info("Processing IMC: {}", imc);
            AutoSwitchApi.ApiEntry<?> entry = AutoSwitchApi.INSTANCE.getEntryMap().get(ResourceLocation.tryBuild((String)imc.modId(), (String)imc.method()));
            if (entry != null) {
                try {
                    Constants.LOG.info("Registered API entry");
                    entry.addUnknown(imc.messageSupplier().get());
                }
                catch (ClassCastException e) {
                    Constants.LOG.error("A mod (maybe '" + imc.senderModId() + "') has passed the incorrect object to AutoSwitch via the IMC", (Throwable)e);
                }
            } else {
                Constants.LOG.warn("Unknown IMC: {}", (Object)ResourceLocation.tryBuild((String)imc.modId(), (String)imc.method()));
            }
        });
    }

    private static void onTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        while (((KeyMapping)SWITCH_TOGGLE.get()).consumeClick()) {
            if (Constants.performSwitch = CommonClass.keybindingToggleAction((Player)mc.player, Constants.performSwitch, !Constants.performSwitch && (mc.isLocalServer() || Constants.CONFIG.featureConfig.switchInMp), "msg.autoswitch.toggle_true", "msg.autoswitch.toggle_false")) continue;
            Constants.SWITCH_STATE.reset();
            Constants.SCHEDULER.reset();
        }
        if (!mc.isPaused() && mc.level != null) {
            ProfilerFiller profiler = Profiler.get();
            profiler.push("autoswitch:schedulerTick");
            Constants.SCHEDULER.tick();
            profiler.pop();
        }
    }

    public static void registerBindings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)SWITCH_TOGGLE.get());
    }
}

