/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.api.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class AutoSwitchApi {
    public static final AutoSwitchApi INSTANCE = new AutoSwitchApi();
    private final HashMap<ResourceLocation, ApiEntry<?>> entryMap = new HashMap();
    public final ApiEntry<Predicate<ItemStack>> DEPLETED = this.register("depletion");

    private AutoSwitchApi() {
    }

    public Collection<ApiEntry<?>> getEntries() {
        return this.entryMap.values();
    }

    public HashMap<ResourceLocation, ApiEntry<?>> getEntryMap() {
        return this.entryMap;
    }

    private <T> ApiEntry<T> register(String id) {
        ApiEntry entry = new ApiEntry(id);
        this.entryMap.put(entry.id(), entry);
        return entry;
    }

    public record ApiEntry<T>(ResourceLocation id, Set<T> entries) implements Iterable<T>
    {
        public ApiEntry(String id) {
            this(ResourceLocation.fromNamespaceAndPath((String)"autoswitch", (String)id), Collections.synchronizedSet(new ApiSet()));
        }

        public void addEntry(T t) {
            this.entries.add(Objects.requireNonNull(t));
        }

        public void addUnknown(Object o) throws ClassCastException {
            this.entries.add(Objects.requireNonNull(o));
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return this.entries().iterator();
        }
    }

    private static class ApiSet<T>
    extends HashSet<T> {
        private ApiSet() {
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Cannot remove entries from autoswitch api!");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Cannot remove entries from autoswitch api!");
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private final Iterator<T> i;
                {
                    this.i = ApiSet.super.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public T next() {
                    return this.i.next();
                }
            };
        }

        @Override
        public boolean removeIf(@NotNull Predicate<? super T> filter) {
            throw new UnsupportedOperationException("Cannot remove entries from autoswitch api!");
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException("Cannot remove entries from autoswitch api!");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Cannot remove entries from autoswitch api!");
        }

        @Override
        public boolean add(T t) {
            return super.add(Objects.requireNonNull(t));
        }
    }
}

