/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.types.data;

import dex.autoswitch.Constants;
import dex.autoswitch.config.data.tree.DataMap;
import dex.autoswitch.engine.data.Match;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.data.extensible.DataType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;

public class ComponentData
extends DataType<DataMap> {
    public static final ComponentData INSTANCE = new ComponentData();

    private ComponentData() {
        super("components", DataMap.class);
    }

    @Override
    public Match matches(int baseLevel, SelectionContext context, Object selectable, DataMap data) {
        if (selectable instanceof ItemStack) {
            ItemStack stack = (ItemStack)selectable;
            return new Match(this.process((DataComponentGetter)stack, data));
        }
        return new Match(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processComponent(DataComponentGetter dataComponentGetter, String id, DataMap map) {
        String pid;
        if (map == null) {
            return false;
        }
        ResourceLocation idRl = ResourceLocation.tryParse((String)id);
        if (idRl == null) {
            Constants.LOG.warn("Component id '{}' incorrectly formated", (Object)id);
            return false;
        }
        Optional maybeComp = BuiltInRegistries.DATA_COMPONENT_TYPE.get(idRl);
        if (maybeComp.isEmpty() || ((Holder.Reference)maybeComp.get()).value() == null) {
            Constants.LOG.warn("Component id '{}' not found", (Object)id);
            return false;
        }
        DataComponentType comp = (DataComponentType)((Holder.Reference)maybeComp.get()).value();
        if (comp != DataComponents.POTION_CONTENTS) return false;
        TypedDataComponent potions = dataComponentGetter.getTyped(DataComponents.POTION_CONTENTS);
        if (potions == null) return false;
        if (!(map instanceof DataMap.Value)) return false;
        DataMap.Value value = (DataMap.Value)map;
        try {
            String string;
            pid = string = value.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        ResourceLocation prl = ResourceLocation.tryParse((String)pid);
        if (prl == null || !((PotionContents)potions.value()).potion().isPresent()) return false;
        return ((Holder)((PotionContents)potions.value()).potion().get()).is(prl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean process(DataComponentGetter dataComponentGetter, DataMap dataMap) {
        DataMap dataMap2 = dataMap;
        Objects.requireNonNull(dataMap2);
        DataMap dataMap3 = dataMap2;
        int n = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataMap.Map.class, DataMap.Pair.class, DataMap.Value.class, DataMap.Pair.class}, (Object)dataMap3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DataMap.Map map = (DataMap.Map)dataMap3;
                    return this.process(dataComponentGetter, map);
                }
                case 1: {
                    String key;
                    Object object;
                    DataMap.Pair pair = (DataMap.Pair)dataMap3;
                    try {
                        object = pair.key();
                        key = object;
                        object = pair.value();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (object instanceof DataMap.Value) {
                        DataMap.Value mv = (DataMap.Value)object;
                        return this.processComponent(dataComponentGetter, key, mv);
                    }
                    n = 2;
                    continue block8;
                }
                case 2: {
                    DataMap.Value value = (DataMap.Value)dataMap3;
                    return false;
                }
                case 3: 
            }
            break;
        }
        DataMap.Pair pair = (DataMap.Pair)dataMap3;
        return false;
    }
}

