/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.types.data;

import dex.autoswitch.Constants;
import dex.autoswitch.config.data.tree.DataMap;
import dex.autoswitch.engine.data.Match;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.data.extensible.DataType;
import dex.autoswitch.engine.types.selectable.ItemSelectableType;
import dex.autoswitch.futures.FutureSelectable;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class EntityEquipmentData
extends DataType<DataMap> {
    public static final EntityEquipmentData INSTANCE = new EntityEquipmentData();

    protected EntityEquipmentData() {
        super("equipment", DataMap.class);
    }

    @Override
    public Match matches(int baseLevel, SelectionContext context, Object selectable, DataMap data) {
        if (selectable instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)selectable;
            Set<Equipment> requiredState = this.process(data);
            for (Equipment equipment : requiredState) {
                EquipmentSlot slot = this.getSlot(equipment);
                if (slot == null) {
                    return new Match(false);
                }
                ItemStack stack = entity.getItemBySlot(slot);
                FutureSelectable<ResourceLocation, Holder<Item>> desired = FutureSelectable.getOrCreate(ResourceLocation.tryParse((String)equipment.item()), ItemSelectableType.INSTANCE, false);
                if (desired.matches(context, stack)) continue;
                return new Match(false);
            }
            return new Match(true);
        }
        return new Match(false);
    }

    private EquipmentSlot getSlot(Equipment equipment) {
        try {
            return EquipmentSlot.byName((String)equipment.slot());
        }
        catch (Exception e) {
            Constants.LOG.warn("Unknown equipment slot: {}", (Object)equipment.slot());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<Equipment> process(DataMap dataMap) {
        HashSet<Equipment> properties = new HashSet<Equipment>();
        DataMap dataMap2 = dataMap;
        Objects.requireNonNull(dataMap2);
        DataMap dataMap3 = dataMap2;
        int n = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataMap.Map.class, DataMap.Pair.class, DataMap.Value.class, DataMap.Pair.class}, (Object)dataMap3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DataMap.Map map = (DataMap.Map)dataMap3;
                    Object pair = map.entries().iterator();
                    while (pair.hasNext()) {
                        DataMap dataMap4 = (DataMap)pair.next();
                        properties.addAll(this.process(dataMap4));
                    }
                    return properties;
                }
                case 1: {
                    String string;
                    Object object;
                    Object pair = (DataMap.Pair)dataMap3;
                    try {
                        object = ((DataMap.Pair)pair).key();
                        string = object;
                        object = ((DataMap.Pair)pair).value();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (object instanceof DataMap.Value) {
                        DataMap.Value mv = (DataMap.Value)object;
                        properties.add(new Equipment(string, mv.value()));
                        return properties;
                    }
                    n = 2;
                    continue block8;
                }
                case 2: {
                    DataMap.Value value = (DataMap.Value)dataMap3;
                    return properties;
                }
                case 3: 
            }
            break;
        }
        DataMap.Pair pair = (DataMap.Pair)dataMap3;
        return properties;
    }

    private record Equipment(String slot, String item) {
    }
}

