/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.types.selectable;

import dex.autoswitch.engine.TargetType;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.types.selectable.SelectableResource;
import dex.autoswitch.futures.FutureSelectable;
import dex.autoswitch.platform.Services;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class EntitySelectableType
extends SelectableResource<EntityType<?>> {
    public static final EntitySelectableType INSTANCE = new EntitySelectableType();

    protected EntitySelectableType() {
        super("entity");
    }

    @Override
    public Holder<EntityType<?>> lookup(ResourceLocation resourceLocation) {
        return BuiltInRegistries.ENTITY_TYPE.get(resourceLocation).orElse(null);
    }

    @Override
    public TagKey<EntityType<?>> lookupGroup(ResourceLocation resourceLocation) {
        return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)resourceLocation);
    }

    @Override
    public boolean matches(SelectionContext context, Holder<EntityType<?>> v, Object selectable) {
        EntityType ref = (EntityType)v.value();
        if (selectable instanceof Entity) {
            Entity entity = (Entity)selectable;
            return ref.equals(entity.getType());
        }
        if (selectable instanceof EntityType) {
            EntityType type = (EntityType)selectable;
            return ref.equals(type);
        }
        return false;
    }

    @Override
    public boolean matchesGroup(SelectionContext context, TagKey<EntityType<?>> tagKey, Object selectable) {
        if (selectable instanceof Entity) {
            Entity entity = (Entity)selectable;
            return Services.PLATFORM.isInTag(tagKey, entity.getType());
        }
        if (selectable instanceof EntityType) {
            EntityType type = (EntityType)selectable;
            return Services.PLATFORM.isInTag(tagKey, type);
        }
        return false;
    }

    @Override
    @Nullable
    public TargetType targetType() {
        return TargetType.ENTITIES;
    }

    @Override
    public boolean isOf(Object o) {
        Holder h;
        return o instanceof Entity || o instanceof EntityType || o instanceof Holder && (h = (Holder)o).value() instanceof Entity;
    }

    @Override
    public double typeRating(SelectionContext context, FutureSelectable<ResourceLocation, Holder<EntityType<?>>> futureValue, Object selectable) {
        return 0.0;
    }
}

