/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.types.selectable;

import dex.autoswitch.Constants;
import dex.autoswitch.api.impl.AutoSwitchApi;
import dex.autoswitch.engine.Action;
import dex.autoswitch.engine.TargetType;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.types.selectable.SelectableResource;
import dex.autoswitch.futures.FutureSelectable;
import dex.autoswitch.platform.Services;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.Nullable;

public class ItemSelectableType
extends SelectableResource<Item> {
    public static final ItemSelectableType INSTANCE = new ItemSelectableType();

    public ItemSelectableType() {
        super("item");
    }

    @Override
    public Holder<Item> lookup(ResourceLocation resourceLocation) {
        return BuiltInRegistries.ITEM.get(resourceLocation).orElse(null);
    }

    @Override
    public TagKey<Item> lookupGroup(ResourceLocation resourceLocation) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)resourceLocation);
    }

    @Override
    public boolean matches(SelectionContext context, Holder<Item> v, Object selectable) {
        Item item;
        BlockState state;
        Object object;
        Item ref = (Item)v.value();
        if (selectable instanceof ItemStack) {
            ItemStack stack = (ItemStack)selectable;
            if (Constants.CONFIG.featureConfig.skipDepletedItems) {
                for (Predicate<ItemStack> stackPredicate : AutoSwitchApi.INSTANCE.DEPLETED) {
                    if (!stackPredicate.test(stack)) continue;
                    return false;
                }
            }
            if (ref.equals(stack.getItem())) {
                object = context.target();
                if (object instanceof BlockState) {
                    state = (BlockState)object;
                    return this.isCorrectTool(stack, state);
                }
                return true;
            }
        }
        if (selectable instanceof Item && ref.equals(item = (Item)selectable)) {
            object = context.target();
            if (object instanceof BlockState) {
                state = (BlockState)object;
                return this.isCorrectTool(item, state);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesGroup(SelectionContext context, TagKey<Item> itemTagKey, Object selectable) {
        Item item;
        BlockState state;
        Object object;
        if (selectable instanceof ItemStack) {
            ItemStack stack = (ItemStack)selectable;
            if (Constants.CONFIG.featureConfig.skipDepletedItems) {
                for (Predicate<ItemStack> stackPredicate : AutoSwitchApi.INSTANCE.DEPLETED) {
                    if (!stackPredicate.test(stack)) continue;
                    return false;
                }
            }
            if (Services.PLATFORM.isInTag(itemTagKey, stack.getItem())) {
                object = context.target();
                if (object instanceof BlockState) {
                    state = (BlockState)object;
                    return this.isCorrectTool(stack, state);
                }
                return true;
            }
        }
        if (selectable instanceof Item && Services.PLATFORM.isInTag(itemTagKey, item = (Item)selectable)) {
            object = context.target();
            if (object instanceof BlockState) {
                state = (BlockState)object;
                return this.isCorrectTool(item, state);
            }
            return true;
        }
        return false;
    }

    private boolean isCorrectTool(ItemStack stack, BlockState state) {
        return !state.requiresCorrectToolForDrops() || stack.isCorrectToolForDrops(state);
    }

    private boolean isCorrectTool(Item item, BlockState state) {
        Tool tool = (Tool)item.components().get(DataComponents.TOOL);
        if (!state.requiresCorrectToolForDrops()) {
            return true;
        }
        return tool != null && tool.isCorrectForDrops(state);
    }

    @Override
    @Nullable
    public TargetType targetType() {
        return null;
    }

    @Override
    public boolean isOf(Object o) {
        Holder h;
        return o instanceof ItemStack || o instanceof Item || o instanceof Holder && (h = (Holder)o).value() instanceof Item;
    }

    @Override
    public double typeRating(SelectionContext context, FutureSelectable<ResourceLocation, Holder<Item>> futureValue, Object selectable) {
        if (context.action() != Action.ATTACK) {
            if (selectable instanceof ItemStack) {
                ItemStack stack = (ItemStack)selectable;
                if (stack.isDamageableItem()) {
                    if (stack.getMaxDamage() > 0) {
                        return (double)stack.getDamageValue() / (double)stack.getMaxDamage();
                    }
                } else if (stack.isStackable()) {
                    return (double)stack.getCount() / (double)stack.getMaxStackSize();
                }
            }
            return 0.0;
        }
        if (selectable instanceof ItemStack) {
            Object tool;
            ItemStack stack = (ItemStack)selectable;
            Object object = context.target();
            if (object instanceof BlockState) {
                BlockState state = (BlockState)object;
                tool = (Tool)stack.get(DataComponents.TOOL);
                double defaultSpeed = 1.0;
                if (tool != null) {
                    defaultSpeed = tool.defaultMiningSpeed();
                }
                double normSpeed = ((double)stack.getDestroySpeed(state) - defaultSpeed) / defaultSpeed;
                if (Constants.CONFIG.featureConfig.preferMinimumViableTool) {
                    normSpeed = 1.0 - normSpeed;
                }
                return normSpeed;
            }
            tool = context.target();
            if (tool instanceof Entity) {
                Entity entity = (Entity)tool;
                MutableDouble damage = new MutableDouble(1.0);
                MutableDouble speed = new MutableDouble(4.0);
                stack.forEachModifier(EquipmentSlot.MAINHAND, (attributeHolder, attributeModifier) -> {
                    double d0;
                    double d1;
                    int baseValue;
                    if (attributeHolder.is(Attributes.ATTACK_DAMAGE)) {
                        baseValue = 1;
                        d1 = attributeModifier.amount();
                        d0 = damage.doubleValue();
                        damage.setValue(d0 += (switch (attributeModifier.operation()) {
                            default -> throw new MatchException(null, null);
                            case AttributeModifier.Operation.ADD_VALUE -> d1;
                            case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> d1 * (double)baseValue;
                            case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> d1 * d0;
                        }));
                    }
                    if (attributeHolder.is(Attributes.ATTACK_SPEED)) {
                        baseValue = 4;
                        d1 = attributeModifier.amount();
                        d0 = speed.doubleValue();
                        speed.setValue(d0 += (switch (attributeModifier.operation()) {
                            default -> throw new MatchException(null, null);
                            case AttributeModifier.Operation.ADD_VALUE -> d1;
                            case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> d1 * (double)baseValue;
                            case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> d1 * d0;
                        }));
                    }
                });
                if (speed.doubleValue() == 0.0 || damage.doubleValue() == 0.0) {
                    return 0.0;
                }
                return damage.doubleValue() * speed.doubleValue();
            }
        }
        return 0.0;
    }

    private static float clampMiningSpeed(float original) {
        if (original > 0.0f) {
            return (float)(6.25 * Math.log10(original) / (double)original);
        }
        return original;
    }
}

