/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.futures;

import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.data.extensible.SelectableType;
import dex.autoswitch.futures.FutureSelectableGroup;
import dex.autoswitch.futures.FutureSelectableValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract sealed class FutureSelectable<KEY, TYPE>
permits FutureSelectableValue, FutureSelectableGroup {
    protected static final Map<Key<?>, FutureSelectable<?, ?>> INSTANCES = new HashMap();
    protected final KEY key;
    protected final SelectableType<KEY, TYPE, ?> selectableType;
    protected Status status = Status.UNVERIFIED;

    public FutureSelectable(KEY key, SelectableType<KEY, TYPE, ?> type) {
        this.key = Objects.requireNonNull(key, "key must not be null");
        this.selectableType = Objects.requireNonNull(type, "type must not be null");
    }

    public static void invalidateValues() {
        INSTANCES.forEach((i, future) -> {
            future.status = Status.UNVERIFIED;
        });
    }

    public static <K, T, G> FutureSelectable<K, T> getOrCreate(K key, SelectableType<K, T, G> type, boolean isGroup) {
        Key<K> k = new Key<K>(key, type, isGroup);
        if (isGroup) {
            INSTANCES.putIfAbsent(k, new FutureSelectableGroup<K, T, G>(key, type));
            return (FutureSelectableGroup)INSTANCES.get(k);
        }
        INSTANCES.putIfAbsent(k, new FutureSelectableValue<K, T>(key, type));
        return (FutureSelectableValue)INSTANCES.get(k);
    }

    public abstract boolean matches(SelectionContext var1, Object var2);

    public abstract void validate();

    public double rating(SelectionContext context, Object selectable) {
        return this.selectableType.typeRating(context, this, selectable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FutureSelectable)) {
            return false;
        }
        FutureSelectable that = (FutureSelectable)o;
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.key.equals(that.key) && this.selectableType.equals(that.selectableType);
    }

    public KEY getKey() {
        return this.key;
    }

    public SelectableType<KEY, TYPE, ?> getSelectorType() {
        return this.selectableType;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.key, this.selectableType);
    }

    protected static enum Status {
        UNVERIFIED,
        VALID,
        INVALID;

    }

    public record Key<K>(K key, SelectableType<K, ?, ?> type, boolean isGroup) {
    }
}

