/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.mixin.mixins;

import dex.autoswitch.mixin.impl.SwitchEventTriggerImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MultiPlayerGameMode.class})
public abstract class MixinMultiPlayerGameMode {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private boolean isDestroying;
    @Unique
    private HitResult autoswitch$prevTarget;

    @Inject(at={@At(value="HEAD")}, method={"ensureHasSentCarriedItem()V"})
    private void autoswitch$triggerSwitchOnSlotSync(CallbackInfo ci) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("autoswitch:switchTrigger");
        assert (this.minecraft.player != null);
        assert (this.minecraft.hitResult != null);
        if (this.minecraft.hitResult.equals(this.autoswitch$prevTarget)) {
            return;
        }
        if (this.minecraft.options.keyAttack.isDown()) {
            SwitchEventTriggerImpl.attack(0, this.minecraft.player, this.minecraft.hitResult);
            this.autoswitch$prevTarget = this.minecraft.hitResult;
        } else if (this.minecraft.options.keyUse.isDown()) {
            SwitchEventTriggerImpl.interact(this.isDestroying, this.minecraft.player, this.minecraft.hitResult);
            this.autoswitch$prevTarget = this.minecraft.hitResult;
        }
        profiler.pop();
    }
}

