/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.platform;

import com.google.auto.service.AutoService;
import dex.autoswitch.platform.services.IPlatformHelper;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;

@AutoService(value={IPlatformHelper.class})
public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public <T> boolean isInTagGeneral(TagKey<T> tagKey, T t) {
        Optional<Holder<T>> entry;
        Optional<Registry<T>> reg = NeoForgePlatformHelper.getRegistry(this.getRegistryAccess(), tagKey);
        if (reg.isPresent() && reg.get().get(tagKey).isPresent() && (entry = NeoForgePlatformHelper.getRegistryEntry(reg.get(), tagKey, t)).isPresent()) {
            return entry.get().is(tagKey);
        }
        return false;
    }

    private static <T> Optional<? extends Registry<T>> getRegistry(RegistryAccess registryAccess, TagKey<T> tagKey) {
        Objects.requireNonNull(tagKey);
        Optional maybeRegistry = registryAccess.lookup(tagKey.registry());
        if (maybeRegistry.isPresent()) {
            return maybeRegistry;
        }
        return BuiltInRegistries.REGISTRY.getOptional(tagKey.registry().location());
    }

    private static <U extends Registry<T>, T> Optional<Holder<T>> getRegistryEntry(U registry, TagKey<T> tagKey, T entry) {
        if (!tagKey.isFor(registry.key())) {
            return Optional.empty();
        }
        Optional maybeKey = registry.getResourceKey(entry);
        return maybeKey.map(arg_0 -> registry.getOrThrow(arg_0));
    }
}

