/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.platform;

import dex.autoswitch.Constants;
import dex.autoswitch.platform.services.IPlatformHelper;
import java.util.ServiceLoader;

public class Services {
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);

    public static <T> T load(Class<T> clazz) {
        Object loadedService = null;
        for (T loaded : ServiceLoader.load(clazz, Services.class.getClassLoader())) {
            if (loadedService != null) {
                Constants.LOG.warn("Found duplicate platform service {}", loaded.getClass());
                continue;
            }
            loadedService = loaded;
            if (!loadedService.getClass().getName().contains("Test")) continue;
            break;
        }
        if (loadedService == null) {
            throw new NullPointerException("Failed to load service for " + clazz.getName());
        }
        Constants.LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return (T)loadedService;
    }
}

