/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.config;

import dex.autoswitch.config.data.FallbackSelector;
import dex.autoswitch.config.data.tree.ExpressionTree;
import dex.autoswitch.config.subentries.FeatureConfig;
import dex.autoswitch.engine.Action;
import dex.autoswitch.engine.SelectionEngine;
import dex.autoswitch.engine.Selector;
import dex.autoswitch.engine.data.Match;
import dex.autoswitch.engine.data.SwitchRegistry;
import dex.lib.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import dex.lib.org.spongepowered.configurate.objectmapping.meta.Comment;
import dex.lib.org.spongepowered.configurate.objectmapping.meta.PostProcess;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@ConfigSerializable
public class AutoSwitchConfig {
    public static final Selector ANY_ITEM_SELECTOR = new Selector(0, (i, j, k) -> new Match(true));
    public static final Selector FALLBACK = new Selector(Integer.MIN_VALUE, SwitchRegistry.INSTANCE.nonToolMatcher);
    @Comment(value="Control all features")
    public FeatureConfig featureConfig = new FeatureConfig();
    @Comment(value="Control selection when attacking")
    public Set<TargetEntry> attackAction = new HashSet<TargetEntry>();
    @Comment(value="Control selection when interacting")
    public Set<TargetEntry> interactAction = new HashSet<TargetEntry>();
    @Comment(value="Control selection when a stat changes")
    public Set<TargetEntry> statChangeAction = new HashSet<TargetEntry>();
    @Comment(value="Config version to support migration")
    public int configVersion = 1;
    private transient Map<Action, Map<Selector, Set<Selector>>> configuration = null;
    private transient SelectionEngine engine;
    private final transient Set<Object> relevantEvents = new HashSet<Object>();

    public Map<Action, Map<Selector, Set<Selector>>> getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new HashMap<Action, Map<Selector, Set<Selector>>>();
            for (Action action : Action.values()) {
                this.configuration.put(action, this.makeMap(action));
            }
        }
        return this.configuration;
    }

    public SelectionEngine getEngine() {
        if (this.engine == null) {
            this.engine = new SelectionEngine(this.getConfiguration(), new FallbackSelector(this.featureConfig.switchAwayFromTools, FALLBACK));
        }
        return this.engine;
    }

    public boolean isEventRelevant(Object o) {
        return this.relevantEvents.contains(o);
    }

    public void addEventRelevant(Object o) {
        this.relevantEvents.add(o);
    }

    @PostProcess
    public void resetConfiguration() {
        this.configuration = null;
        this.engine = null;
        this.relevantEvents.clear();
    }

    private Map<Selector, Set<Selector>> makeMap(Action action) {
        Set<TargetEntry> entries = this.getEntries(action);
        HashMap<Selector, Set<Selector>> m = new HashMap<Selector, Set<Selector>>();
        for (TargetEntry targetEntry : entries) {
            if (targetEntry.target == null) continue;
            Set<Selector> tools = this.getToolSelectors(targetEntry);
            m.put(new Selector(targetEntry.priority, targetEntry.target), tools);
        }
        return m;
    }

    @NotNull
    private Set<Selector> getToolSelectors(TargetEntry targetEntry) {
        HashSet<Selector> tools = new HashSet<Selector>();
        int p = 0;
        for (ExpressionTree tool : targetEntry.tools) {
            if (tool == null) continue;
            tools.add(new Selector(p--, tool));
        }
        if (tools.isEmpty()) {
            tools.add(ANY_ITEM_SELECTOR);
        }
        return tools;
    }

    private Set<TargetEntry> getEntries(Action action) {
        return switch (action) {
            default -> throw new MatchException(null, null);
            case Action.ATTACK -> this.attackAction;
            case Action.STAT_CHANGE -> this.statChangeAction;
            case Action.INTERACT -> this.interactAction;
        };
    }

    @ConfigSerializable
    public static class TargetEntry {
        @Comment(value="The priority of selecting this target in relation to other valid targets.\nHigher values are preferred.")
        public int priority = 10;
        public ExpressionTree target;
        public ExpressionTree[] tools = new ExpressionTree[0];

        public String toString() {
            return "TargetEntry{priority=" + this.priority + ", target=" + String.valueOf(this.target) + ", tools=" + Arrays.toString(this.tools) + "}";
        }
    }
}

