/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine;

import dex.autoswitch.config.data.tree.Data;
import dex.autoswitch.config.data.tree.DataMap;
import dex.autoswitch.config.data.tree.DisjunctiveUnion;
import dex.autoswitch.config.data.tree.ExpressionTree;
import dex.autoswitch.config.data.tree.IdSelector;
import dex.autoswitch.config.data.tree.Intersection;
import dex.autoswitch.config.data.tree.Invert;
import dex.autoswitch.config.data.tree.TypedData;
import dex.autoswitch.config.data.tree.Union;
import dex.autoswitch.engine.data.Match;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.futures.FutureSelectable;
import dex.autoswitch.futures.FutureSelectableGroup;
import dex.autoswitch.futures.FutureSelectableValue;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@FunctionalInterface
public interface Matcher {
    public Match matches(int var1, SelectionContext var2, Object var3);

    public static String prettyPrint(Matcher matcher) {
        return Matcher.prettyPrint(matcher, 0);
    }

    public static String prettyPrint(Matcher matcher, int level) {
        Matcher matcher2 = matcher;
        Objects.requireNonNull(matcher2);
        Matcher matcher3 = matcher2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DisjunctiveUnion.class, Intersection.class, Invert.class, Union.class, IdSelector.class, TypedData.class}, (Object)matcher3, n)) {
            case 0 -> {
                DisjunctiveUnion disjunctiveUnion = (DisjunctiveUnion)matcher3;
                yield "XOR{\n" + disjunctiveUnion.children().stream().map(child -> Matcher.prettyPrint(child, level + 1)).collect(Collectors.joining("\n" + " ".repeat(level))) + "\n" + " ".repeat(level) + "}";
            }
            case 1 -> {
                Intersection intersection = (Intersection)matcher3;
                yield "OR{\n" + intersection.children().stream().map(child -> Matcher.prettyPrint(child, level + 1)).collect(Collectors.joining("\n" + " ".repeat(level))) + "\n" + " ".repeat(level) + "}";
            }
            case 2 -> {
                Invert invert = (Invert)matcher3;
                yield "NOT[" + Matcher.prettyPrint(invert.child(), level) + "]";
            }
            case 3 -> {
                Union union = (Union)matcher3;
                yield "AND{\n" + union.children().stream().map(child -> Matcher.prettyPrint(child, level + 1)).collect(Collectors.joining("\n" + " ".repeat(level))) + "\n" + " ".repeat(level) + "}";
            }
            case 4 -> {
                IdSelector idSelector = (IdSelector)matcher3;
                StringBuilder sb = new StringBuilder(idSelector.selectable().getSelectorType().id());
                sb.append('[');
                FutureSelectable<?, ?> v2 = idSelector.selectable();
                Objects.requireNonNull(v2);
                FutureSelectable<?, ?> var10_11 = v2;
                int var11_13 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FutureSelectableGroup.class, FutureSelectableValue.class}, var10_11, var11_13)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        FutureSelectableGroup v = (FutureSelectableGroup)var10_11;
                        sb.append('#').append(v.getKey());
                        break;
                    }
                    case 1: {
                        FutureSelectableValue v = (FutureSelectableValue)var10_11;
                        sb.append(v.getKey());
                    }
                }
                sb.append(']');
                Set<TypedData> subData = idSelector.data();
                for (TypedData subDatum : subData) {
                    sb.append('\n').append(" ".repeat(level));
                    sb.append(Matcher.prettyPrint(subDatum, level + 1));
                }
                yield " ".repeat(level) + sb.toString();
            }
            case 5 -> {
                TypedData typedData = (TypedData)matcher3;
                StringBuilder sb = new StringBuilder(" ".repeat(level));
                sb.append(typedData.type().id());
                sb.append('[');
                sb.append(Matcher.prettyPrint(typedData.data(), level + 1));
                sb.append(']');
                yield sb.toString();
            }
            default -> "<Fallback>";
        };
    }

    private static String prettyPrint(Data data, int level) {
        Data data2 = data;
        Objects.requireNonNull(data2);
        Data data3 = data2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataMap.Pair.class, DataMap.Value.class, DataMap.Map.class, ExpressionTree.class}, (Object)data3, n)) {
            case 0 -> {
                DataMap.Pair pair = (DataMap.Pair)data3;
                yield pair.key() + ": " + Matcher.prettyPrint(pair.value(), level + 1);
            }
            case 1 -> {
                DataMap.Value value = (DataMap.Value)data3;
                yield value.value();
            }
            case 2 -> {
                DataMap.Map map = (DataMap.Map)data3;
                yield map.entries().stream().map(entry -> Matcher.prettyPrint(entry, level + 1)).collect(Collectors.joining("\n" + " ".repeat(level)));
            }
            case 3 -> {
                ExpressionTree tree = (ExpressionTree)data3;
                yield Matcher.prettyPrint(tree, level + 1);
            }
            default -> data.toString();
        };
    }
}

