/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.data;

import dex.autoswitch.engine.Matcher;
import dex.autoswitch.engine.data.Match;
import dex.autoswitch.engine.data.extensible.DataType;
import dex.autoswitch.engine.data.extensible.SelectableType;
import dex.autoswitch.engine.data.extensible.SwitchRegistryService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class SwitchRegistry {
    public static final SwitchRegistry INSTANCE = new SwitchRegistry();
    public final Matcher nonToolMatcher;
    private final HashMap<String, SelectableType<?, ?, ?>> SELECTABLE_TYPES = new HashMap();
    private final HashMap<String, DataType<?>> DATA_TYPES = new HashMap();

    private SwitchRegistry() {
        Matcher nonTool = null;
        ServiceLoader<SwitchRegistryService> loader = ServiceLoader.load(SwitchRegistryService.class, SwitchRegistry.class.getClassLoader());
        for (SwitchRegistryService registryService : loader) {
            SelectableType<?, ?, ?> selType2;
            Set<SelectableType<?, ?, ?>> selTypes = registryService.selectableTypes();
            for (SelectableType<?, ?, ?> selType2 : selTypes) {
                if (this.SELECTABLE_TYPES.put(selType2.id(), selType2) == null) continue;
                throw new IllegalArgumentException("Tried to create SelectorType with existing id " + selType2.id());
            }
            Set<DataType<?>> dataTypes = registryService.dataTypes();
            selType2 = dataTypes.iterator();
            while (selType2.hasNext()) {
                DataType dataType = (DataType)selType2.next();
                if (this.DATA_TYPES.put(dataType.id(), dataType) == null) continue;
                throw new IllegalArgumentException("Tried to create DataType with existing id " + dataType.id());
            }
            Matcher registeredTool = registryService.nonToolMatcher();
            if (nonTool == null) {
                nonTool = registeredTool;
                continue;
            }
            if (registeredTool == null) continue;
            throw new IllegalArgumentException("Tried to create second blank tool selector");
        }
        if (nonTool == null) {
            nonTool = (i, j, k) -> new Match(false);
        }
        this.nonToolMatcher = nonTool;
    }

    public DataType<?> getDataType(String id) {
        Objects.requireNonNull(id);
        id = id.toUpperCase(Locale.ENGLISH);
        DataType<?> i = this.DATA_TYPES.get(id);
        if (i != null) {
            return i;
        }
        throw new IllegalArgumentException("Tried to fetch DataType with invalid id " + id);
    }

    public SelectableType<?, ?, ?> getSelectableType(String id) {
        Objects.requireNonNull(id);
        id = id.toUpperCase(Locale.ENGLISH);
        SelectableType<?, ?, ?> i = this.SELECTABLE_TYPES.get(id);
        if (i != null) {
            return i;
        }
        throw new IllegalArgumentException("Tried to fetch SelectorType with invalid id " + id);
    }

    @Nullable
    public SelectableType<?, ?, ?> getSelectableType(Object o) {
        for (SelectableType<?, ?, ?> selectableType : this.SELECTABLE_TYPES.values()) {
            if (!selectableType.isOf(o)) continue;
            return selectableType;
        }
        return null;
    }

    public Collection<SelectableType<?, ?, ?>> getSelectableTypes() {
        return this.SELECTABLE_TYPES.values();
    }
}

