/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.mixin.impl;

import dex.autoswitch.Constants;
import dex.autoswitch.engine.Action;
import dex.autoswitch.engine.TargetType;
import dex.autoswitch.engine.events.SwitchEvent;
import dex.autoswitch.engine.state.SwitchContext;
import dex.autoswitch.engine.types.SwitchedPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stat;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class SwitchEventTriggerImpl {
    public static void attack(int attackCooldown, LocalPlayer player, HitResult crosshairTarget) {
        if (attackCooldown > 0 || player.isHandsBusy() || crosshairTarget == null) {
            return;
        }
        SwitchEventTriggerImpl.triggerSwitch(DesiredType.ATTACK, crosshairTarget, player);
    }

    public static void interact(boolean isBreakingBlock, LocalPlayer player, HitResult crosshairTarget) {
        if (isBreakingBlock || player.isHandsBusy() || crosshairTarget == null) {
            return;
        }
        SwitchEventTriggerImpl.triggerSwitch(DesiredType.USE, crosshairTarget, player);
    }

    public static void eventTrigger(Stat<?> stat, Player player) {
        if (stat == null || player == null || !Constants.performSwitch || !Constants.CONFIG.featureConfig.switchAllowed.contains((Object)TargetType.EVENTS) || SwitchEventTriggerImpl.canNotSwitch(player)) {
            return;
        }
        SwitchContext context = new SwitchContext(new SwitchedPlayer(player), Constants.CONFIG, Action.STAT_CHANGE, stat, Constants.SWITCH_STATE, Constants.SCHEDULER);
        Constants.SCHEDULER.schedule(SwitchEvent.STAT_CHANGE, context, 0);
        Constants.SCHEDULER.tick();
    }

    private static void triggerSwitch(DesiredType desiredType, HitResult crosshairTarget, LocalPlayer player) {
        boolean doSwitchType;
        SwitchEvent event;
        switch (desiredType.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                event = SwitchEvent.INTERACT;
                boolean bl = Constants.CONFIG.featureConfig.switchActions.contains((Object)Action.INTERACT);
                break;
            }
            case 1: {
                event = SwitchEvent.ATTACK;
                boolean bl = Constants.CONFIG.featureConfig.switchActions.contains((Object)Action.INTERACT) && Constants.CONFIG.featureConfig.switchAllowed.contains((Object)(crosshairTarget.getType() == HitResult.Type.ENTITY ? TargetType.ENTITIES : TargetType.BLOCKS)) ? true : (doSwitchType = false);
            }
        }
        if (!doSwitchType || !Constants.performSwitch || SwitchEventTriggerImpl.canNotSwitch((Player)player)) {
            return;
        }
        switch (crosshairTarget.getType()) {
            case MISS: {
                if (desiredType == DesiredType.USE) break;
                break;
            }
            case ENTITY: {
                EntityHitResult entityHitResult = (EntityHitResult)crosshairTarget;
                Entity entity = entityHitResult.getEntity();
                SwitchContext context = new SwitchContext(new SwitchedPlayer((Player)player), Constants.CONFIG, desiredType.action, entity, Constants.SWITCH_STATE, Constants.SCHEDULER);
                Constants.SCHEDULER.schedule(event, context, 0);
                break;
            }
            case BLOCK: {
                if (desiredType == DesiredType.ATTACK && Constants.SWITCH_STATE.preventBlockAttack()) break;
                BlockHitResult blockHitResult = (BlockHitResult)crosshairTarget;
                BlockPos blockPos = blockHitResult.getBlockPos();
                BlockState blockState = player.level().getBlockState(blockPos);
                if (blockState.isAir()) break;
                SwitchContext context = new SwitchContext(new SwitchedPlayer((Player)player), Constants.CONFIG, desiredType.action, blockState, Constants.SWITCH_STATE, Constants.SCHEDULER);
                Constants.SCHEDULER.schedule(event, context, 0);
            }
        }
        Constants.SCHEDULER.tick();
    }

    private static boolean canNotSwitch(Player player) {
        Minecraft mc = Minecraft.getInstance();
        boolean inSP = true;
        if (mc != null) {
            inSP = mc.isLocalServer();
        }
        return Constants.CONFIG.featureConfig.disableWhenCrouched && player.isCrouching() || !Constants.CONFIG.featureConfig.switchInCreative && player.isCreative() || !Constants.CONFIG.featureConfig.switchInMp && inSP;
    }

    static enum DesiredType {
        USE(Action.INTERACT),
        ATTACK(Action.ATTACK);

        private final Action action;

        private DesiredType(Action action) {
            this.action = action;
        }
    }
}

