/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.platform.services;

import dex.autoswitch.Tags;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.tags.TagKey;

public interface IPlatformHelper {
    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    public Path getConfigDir();

    public <T> boolean isInTagGeneral(TagKey<T> var1, T var2);

    default public RegistryAccess getRegistryAccess() {
        if (Minecraft.getInstance() != null && Minecraft.getInstance().level != null && Minecraft.getInstance().level.registryAccess() != null) {
            return Minecraft.getInstance().level.registryAccess();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> boolean isInTag(TagKey<T> tagKey, T t) {
        boolean bl;
        Tags.Group<T> group = Tags.getTag(tagKey);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Tags.Group.CustomPredicate.class, Tags.Group.CustomTag.class}, group, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Tags.Group.CustomPredicate v = (Tags.Group.CustomPredicate)group;
                bl = v.predicate().test(t);
                return bl;
            }
            case 1: {
                TagKey tagKey2;
                Object object;
                Tags.Group.CustomTag customTag = (Tags.Group.CustomTag)group;
                try {
                    object = customTag.entries();
                    Set entries = object;
                    object = customTag.includedTags();
                    Set<Object> includedTags = object;
                    if (entries.contains(t)) {
                        return true;
                    }
                    object = includedTags.iterator();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                do {
                    if (object.hasNext()) continue;
                    return false;
                } while (!this.isInTag(tagKey2 = (TagKey)object.next(), t));
                return true;
            }
            case -1: 
        }
        bl = this.isInTagGeneral(tagKey, t);
        return bl;
    }

    default public String getEnvironmentName() {
        return this.isDevelopmentEnvironment() ? "development" : "production";
    }
}

