/*
 * Decompiled with CFR 0.152.
 */
package dex.lib.org.spongepowered.configurate.reference;

import dex.lib.org.spongepowered.configurate.ConfigurateException;
import dex.lib.org.spongepowered.configurate.ScopedConfigurationNode;
import dex.lib.org.spongepowered.configurate.loader.ConfigurationLoader;
import dex.lib.org.spongepowered.configurate.reactive.Disposable;
import dex.lib.org.spongepowered.configurate.reactive.Subscriber;
import dex.lib.org.spongepowered.configurate.reference.ConfigurationReference;
import dex.lib.org.spongepowered.configurate.reference.DirectoryListenerRegistration;
import dex.lib.org.spongepowered.configurate.reference.PrefixedNameThreadFactory;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class WatchServiceListener
implements AutoCloseable {
    private static final WatchEvent.Kind<?>[] DEFAULT_WATCH_EVENTS = new WatchEvent.Kind[]{StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    private static final int PARALLEL_THRESHOLD = 100;
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new PrefixedNameThreadFactory("Configurate-WatchService", true);
    private final WatchService watchService;
    private volatile boolean open = true;
    private final Thread executor;
    final Executor taskExecutor;
    private final ConcurrentHashMap<Path, DirectoryListenerRegistration> activeListeners = new ConcurrentHashMap();
    private static final ThreadLocal<IOException> exceptionHolder = new ThreadLocal();

    public static Builder builder() {
        return new Builder();
    }

    public static WatchServiceListener create() throws IOException {
        return new WatchServiceListener(DEFAULT_THREAD_FACTORY, FileSystems.getDefault(), ForkJoinPool.commonPool());
    }

    private WatchServiceListener(ThreadFactory factory, FileSystem fileSystem, Executor taskExecutor) throws IOException {
        this.watchService = fileSystem.newWatchService();
        this.executor = factory.newThread(() -> {
            while (this.open) {
                WatchKey key;
                try {
                    key = this.watchService.take();
                }
                catch (InterruptedException e) {
                    this.open = false;
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (ClosedWatchServiceException e) {
                    break;
                }
                Path watched = (Path)key.watchable();
                DirectoryListenerRegistration registration = this.activeListeners.get(watched);
                if (registration != null) {
                    HashSet seenContexts = new HashSet();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        if (!key.isValid()) break;
                        if (!seenContexts.add(event.context())) continue;
                        registration.submit(event);
                        if (!registration.closeIfEmpty()) continue;
                        key.cancel();
                        break;
                    }
                    if (!key.reset()) {
                        DirectoryListenerRegistration oldListeners = this.activeListeners.remove(watched);
                        oldListeners.onClose();
                    }
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        });
        this.taskExecutor = taskExecutor;
        this.executor.start();
    }

    private DirectoryListenerRegistration registration(Path directory) throws ConfigurateException {
        @Nullable DirectoryListenerRegistration reg = this.activeListeners.computeIfAbsent(directory, dir -> {
            try {
                return new DirectoryListenerRegistration(dir.register(this.watchService, DEFAULT_WATCH_EVENTS), this.taskExecutor);
            }
            catch (IOException ex) {
                exceptionHolder.set(ex);
                return null;
            }
        });
        if (reg == null) {
            throw new ConfigurateException("While adding listener for " + directory, (Throwable)exceptionHolder.get());
        }
        return reg;
    }

    public Disposable listenToFile(Path file, Subscriber<WatchEvent<?>> callback) throws ConfigurateException, IllegalArgumentException {
        if (Files.isDirectory(file = file.toAbsolutePath(), new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + file + " must be a file");
        }
        Path fileName = file.getFileName();
        return this.registration(file.getParent()).subscribe(fileName, callback);
    }

    public Disposable listenToDirectory(Path directory, Subscriber<WatchEvent<?>> callback) throws ConfigurateException, IllegalArgumentException {
        if (!Files.isDirectory(directory = directory.toAbsolutePath(), new LinkOption[0]) && Files.exists(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + directory + " must be a directory");
        }
        return this.registration(directory).subscribe(callback);
    }

    public <N extends ScopedConfigurationNode<N>> ConfigurationReference<N> listenToConfiguration(Function<Path, ConfigurationLoader<? extends N>> loaderFunc, Path path) throws ConfigurateException {
        return ConfigurationReference.watching(loaderFunc, path, this);
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        this.watchService.close();
        this.activeListeners.forEachValue(100L, DirectoryListenerRegistration::onClose);
        this.activeListeners.clear();
        try {
            this.executor.interrupt();
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to await termination of executor thread!");
        }
    }

    public static final class Builder {
        private @Nullable ThreadFactory threadFactory;
        private @Nullable FileSystem fileSystem;
        private @Nullable Executor taskExecutor;

        private Builder() {
        }

        public Builder threadFactory(ThreadFactory factory) {
            this.threadFactory = Objects.requireNonNull(factory, "factory");
            return this;
        }

        public Builder taskExecutor(Executor executor) {
            this.taskExecutor = Objects.requireNonNull(executor, "executor");
            return this;
        }

        public Builder fileSystem(FileSystem system) {
            this.fileSystem = system;
            return this;
        }

        public WatchServiceListener build() throws IOException {
            if (this.threadFactory == null) {
                this.threadFactory = DEFAULT_THREAD_FACTORY;
            }
            if (this.fileSystem == null) {
                this.fileSystem = FileSystems.getDefault();
            }
            if (this.taskExecutor == null) {
                this.taskExecutor = ForkJoinPool.commonPool();
            }
            return new WatchServiceListener(this.threadFactory, this.fileSystem, this.taskExecutor);
        }
    }
}

