/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch;

import dex.autoswitch.config.AutoSwitchConfig;
import dex.autoswitch.config.AutoSwitchConfigReference;
import dex.autoswitch.config.ConfigHandler;
import dex.autoswitch.engine.events.Scheduler;
import dex.autoswitch.engine.state.SwitchState;
import dex.autoswitch.platform.Services;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constants {
    public static final String MOD_ID = "autoswitch";
    public static final String MOD_NAME = "AutoSwitch";
    public static final Logger LOG = LoggerFactory.getLogger((String)"AutoSwitch");
    private static final Path CONFIG_PATH = Services.PLATFORM.getConfigDir().resolve("autoswitch.conf");
    public static AutoSwitchConfig CONFIG = Constants.loadConfig();
    public static final Scheduler SCHEDULER = new Scheduler();
    public static final SwitchState SWITCH_STATE = new SwitchState();
    public static boolean performSwitch = !Constants.CONFIG.featureConfig.disableOnStartup;

    private static AutoSwitchConfig loadConfig() {
        try {
            URL defaultConfig = Objects.requireNonNull(Constants.class.getResource("/default.conf")).toURI().toURL();
            AutoSwitchConfigReference ref = ConfigHandler.readDynamicConfiguration(CONFIG_PATH, defaultConfig);
            ref.addListener(c -> {
                CONFIG = c;
                LOG.info("Updated config reference");
            });
            return ref.config();
        }
        catch (IOException e) {
            LOG.error("Could not load autoswitch.conf", (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOG.error("Could not load default.conf", (Throwable)e);
        }
        return new AutoSwitchConfig();
    }

    public static void reset() {
        performSwitch = !Constants.CONFIG.featureConfig.disableOnStartup;
        SWITCH_STATE.reset();
        SCHEDULER.reset();
    }
}

