/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public final class Tags {
    private static final Tags INSTANCE = new Tags();
    private final Map<TagKey<?>, Group<?>> tagMap = new HashMap();

    private Tags() {
        this.tagMap.put(Tags.tagKey(Registries.BLOCK, "shears_efficient"), new Group.CustomTag<Block>(Set.of(Blocks.COBWEB, Blocks.SHORT_GRASS, Blocks.FERN, Blocks.LARGE_FERN, Blocks.DEAD_BUSH, Blocks.HANGING_ROOTS, Blocks.VINE, Blocks.TRIPWIRE, Blocks.GLOW_LICHEN, Blocks.BUSH, Blocks.SEAGRASS, Blocks.SHORT_DRY_GRASS, Blocks.TALL_DRY_GRASS, Blocks.TALL_GRASS, Blocks.TALL_SEAGRASS, Blocks.NETHER_SPROUTS, Blocks.WEEPING_VINES, Blocks.WEEPING_VINES_PLANT, Blocks.TWISTING_VINES, Blocks.TWISTING_VINES_PLANT, Blocks.PALE_HANGING_MOSS), Set.of(Tags.mcTag(Registries.BLOCK, "mineable/shears"), BlockTags.WOOL, BlockTags.LEAVES)));
        this.tagMap.put(Tags.tagKey(Registries.BLOCK, "any"), new Group.CustomPredicate<Block>($ -> true));
        this.tagMap.put(Tags.tagKey(Registries.ENTITY_TYPE, "any"), new Group.CustomPredicate<EntityType>($ -> true));
        this.tagMap.put(Tags.tagKey(Registries.ENCHANTMENT, "any"), new Group.CustomPredicate<Enchantment>($ -> true));
        this.tagMap.put(Tags.tagKey(Registries.ITEM, "any"), new Group.CustomPredicate<Item>($ -> true));
    }

    public static <T> Group<T> getTag(TagKey<T> tagKey) {
        return Tags.INSTANCE.tagMap.get(tagKey);
    }

    private static <T> TagKey<T> tagKey(ResourceKey<? extends Registry<T>> registry, String id) {
        return TagKey.create(registry, (Identifier)Identifier.fromNamespaceAndPath((String)"autoswitch", (String)id));
    }

    private static <T> TagKey<T> mcTag(ResourceKey<? extends Registry<T>> registry, String id) {
        return TagKey.create(registry, (Identifier)Identifier.fromNamespaceAndPath((String)"minecraft", (String)id));
    }

    public static sealed interface Group<T> {

        public record CustomPredicate<T>(Predicate<T> predicate) implements Group<T>
        {
        }

        public record CustomTag<T>(Set<T> entries, Set<TagKey<T>> includedTags) implements Group<T>
        {
        }
    }
}

