/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.config.codecs;

import dex.autoswitch.config.ConfigHandler;
import dex.autoswitch.config.data.tree.Data;
import dex.autoswitch.config.data.tree.IdSelector;
import dex.autoswitch.config.data.tree.TypedData;
import dex.autoswitch.engine.data.SwitchRegistry;
import dex.autoswitch.engine.data.extensible.DataType;
import dex.autoswitch.engine.data.extensible.SelectableType;
import dex.autoswitch.futures.FutureSelectable;
import dex.autoswitch.futures.FutureSelectableGroup;
import dex.autoswitch.futures.FutureSelectableValue;
import dex.lib.org.spongepowered.configurate.ConfigurationNode;
import dex.lib.org.spongepowered.configurate.serialize.SerializationException;
import dex.lib.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public final class IdSelectorCodec
implements TypeSerializer<IdSelector> {
    public static final IdSelectorCodec INSTANCE = new IdSelectorCodec();
    private static final String TYPE = "type";
    private static final String ID = "id";
    private static final String TAG = "tag";
    private static final String DATA = "data";

    private IdSelectorCodec() {
    }

    @Override
    public IdSelector deserialize(@NotNull Type type, @NotNull ConfigurationNode node) throws SerializationException {
        Object k;
        SelectableType selType;
        ConfigurationNode idNode = node.node(ID);
        ConfigurationNode tagNode = node.node(TAG);
        ConfigurationNode dataNode = node.node(DATA);
        if (idNode.virtual()) {
            ConfigHandler.LOGGER.warning(IdSelectorCodec.createLogMessage(node, "Failed to find ID"));
            return null;
        }
        try {
            selType = this.getSelectorType(node);
        }
        catch (SerializationException e) {
            ConfigHandler.LOGGER.warning(IdSelectorCodec.createLogMessage(node, "Failed to find type"));
            return null;
        }
        catch (IllegalArgumentException e) {
            ConfigHandler.LOGGER.warning(IdSelectorCodec.createLogMessage(node, "Encountered unknown type: " + node.node(TYPE).getString()));
            return null;
        }
        String idStr = idNode.getString();
        if (idStr == null) {
            throw new SerializationException("Null string id");
        }
        boolean hasPrefix = idStr.startsWith("#");
        if (hasPrefix) {
            idStr = idStr.substring(1);
        }
        boolean isTag = false;
        isTag = tagNode.virtual() ? hasPrefix : tagNode.getBoolean();
        try {
            k = selType.deserializeKey(idStr);
        }
        catch (Exception e) {
            ConfigHandler.LOGGER.warning(IdSelectorCodec.createLogMessage(node, "Invalid id: " + idStr));
            return null;
        }
        HashSet data = new HashSet();
        if (dataNode.isMap()) {
            Map<Object, ? extends ConfigurationNode> children = dataNode.childrenMap();
            for (Map.Entry<Object, ? extends ConfigurationNode> entry : children.entrySet()) {
                Object object = entry.getKey();
                if (object instanceof String) {
                    String key = (String)object;
                    try {
                        DataType dataType = SwitchRegistry.INSTANCE.getDataType(key);
                        data.add(new TypedData<Data>(dataType, (Data)entry.getValue().get(dataType.getSupportedData())));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new SerializationException(e);
                    }
                }
                throw new SerializationException("Unknown key type " + String.valueOf(entry.getKey()));
            }
        }
        return new IdSelector(FutureSelectable.getOrCreate(k, selType, isTag), data);
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable IdSelector selector, @NotNull ConfigurationNode node) throws SerializationException {
        if (selector == null) {
            node.raw(null);
            return;
        }
        SelectableType selType = this.getSelectorType(selector);
        node.node(TYPE).set(selector.selectable().getSelectorType().id());
        node.node(ID).set(selType.serializeKey(selector.selectable().getKey()));
        FutureSelectable<?, ?> futureSelectable = selector.selectable();
        Objects.requireNonNull(futureSelectable);
        FutureSelectable<?, ?> futureSelectable2 = futureSelectable;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FutureSelectableGroup.class, FutureSelectableValue.class}, futureSelectable2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                FutureSelectableGroup v = (FutureSelectableGroup)futureSelectable2;
                node.node(TAG).set(true);
                break;
            }
            case 1: {
                FutureSelectableValue futureSelectableValue = (FutureSelectableValue)futureSelectable2;
            }
        }
        if (selector.data() != null && !selector.data().isEmpty()) {
            for (TypedData typedData : selector.data()) {
                node.node(DATA).node(typedData.type().id()).set(selector.data());
            }
        }
    }

    private <K, V, G> SelectableType<K, V, G> getSelectorType(ConfigurationNode source) throws SerializationException {
        ConfigurationNode typeNode = source.node(TYPE);
        if (!typeNode.virtual()) {
            return this.getSelectorType(typeNode.getString());
        }
        if (!source.virtual()) {
            block11: for (ConfigurationNode p = source; p != null && !p.virtual(); p = p.parent()) {
                Object object = p.key();
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class}, (Object)object, n)) {
                    case 0: {
                        String s;
                        switch (s = (String)object) {
                            case "tools": {
                                return this.getSelectorType("item");
                            }
                            case "enchantments": {
                                return this.getSelectorType("enchantment");
                            }
                        }
                        continue block11;
                    }
                }
            }
        }
        throw new SerializationException("Required field type was not present in node");
    }

    private <K, V, G> SelectableType<K, V, G> getSelectorType(IdSelector selector) {
        return selector.selectable().getSelectorType();
    }

    private <K, V, G> SelectableType<K, V, G> getSelectorType(String id) {
        return SwitchRegistry.INSTANCE.getSelectableType(id);
    }

    private ConfigurationNode nonVirtualNode(ConfigurationNode source, Object ... path) throws SerializationException {
        if (!source.hasChild(path)) {
            throw new SerializationException("Required field " + Arrays.toString(path) + " was not present in node");
        }
        return source.node(path);
    }

    private static String createLogMessage(ConfigurationNode node, String message) {
        return "Error reading config at: " + String.valueOf(node.path()) + "\nError: " + message;
    }
}

