/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.debug.gui;

import dex.autoswitch.Constants;
import dex.autoswitch.engine.Action;
import dex.autoswitch.engine.Matcher;
import dex.autoswitch.engine.Selector;
import dex.autoswitch.engine.data.Match;
import dex.autoswitch.engine.data.SelectionContext;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectReferencePair;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.debug.DebugScreenDisplayer;
import net.minecraft.client.gui.components.debug.DebugScreenEntry;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugText {
    public static void register(BiConsumer<Identifier, DebugScreenEntry> consumer) {
        DebugText.register(consumer, "enchantments", new EnchantmentHelp(false));
        DebugText.register(consumer, "enchantment_tags", new EnchantmentHelp(true));
        DebugText.register(consumer, "item_components", new ItemComponentHelp());
        DebugText.register(consumer, "attack_targets", new TargetHelp(Action.ATTACK));
        DebugText.register(consumer, "interact_targets", new TargetHelp(Action.INTERACT));
        DebugText.register(consumer, "tool_selectors", new ToolSelectorHelp());
        DebugText.register(consumer, "item_tags", new ItemTagHelp());
        DebugText.register(consumer, "entity_tags", new EntityTagHelp());
    }

    private static void register(BiConsumer<Identifier, DebugScreenEntry> consumer, String id, DebugScreenEntry entry) {
        consumer.accept(Identifier.fromNamespaceAndPath((String)"autoswitch", (String)id), entry);
    }

    private record EnchantmentHelp(boolean showTags) implements DebugScreenEntry
    {
        private static final Identifier GROUP_ONE = Identifier.fromNamespaceAndPath((String)"autoswitch", (String)"enchantment_help_one");
        private static final Identifier GROUP_TWO = Identifier.fromNamespaceAndPath((String)"autoswitch", (String)"enchantment_help_two");

        public void display(@NotNull DebugScreenDisplayer displayer, @Nullable Level level, @Nullable LevelChunk levelChunk, @Nullable LevelChunk levelChunk1) {
            if (level == null || Minecraft.getInstance().player == null) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            ItemStack heldItem = player.getMainHandItem();
            if (heldItem.isEnchanted()) {
                displayer.addToGroup(this.showTags ? GROUP_TWO : GROUP_ONE, "Held Item Enchantments:");
                ItemEnchantments enchantments = heldItem.getEnchantments();
                for (Holder enchantment : enchantments.keySet()) {
                    if (this.showTags) {
                        enchantment.tags().forEach(tag -> displayer.addToGroup(GROUP_TWO, "#" + String.valueOf(tag.location())));
                        continue;
                    }
                    displayer.addToGroup(GROUP_ONE, enchantment.getRegisteredName());
                }
            }
        }
    }

    private record ItemComponentHelp() implements DebugScreenEntry
    {
        private static final Identifier GROUP_ONE = Identifier.fromNamespaceAndPath((String)"autoswitch", (String)"component_help_one");

        public void display(@NotNull DebugScreenDisplayer displayer, @Nullable Level level, @Nullable LevelChunk levelChunk, @Nullable LevelChunk levelChunk1) {
            if (level == null || Minecraft.getInstance().player == null) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            ItemStack heldItem = player.getMainHandItem();
            DataComponentMap components = heldItem.getComponents();
            if (components.has(DataComponents.POTION_CONTENTS)) {
                displayer.addToGroup(GROUP_ONE, "Held Item Potion Contents:");
                TypedDataComponent pc = components.getTyped(DataComponents.POTION_CONTENTS);
                if (pc == null) {
                    return;
                }
                displayer.addToGroup(GROUP_ONE, ((PotionContents)pc.value()).potion().map(Holder::getRegisteredName).orElse("unknown"));
            }
        }
    }

    private record TargetHelp(Action action) implements DebugScreenEntry
    {
        private static final Identifier GROUP_ONE = Identifier.fromNamespaceAndPath((String)"autoswitch", (String)"target_help_one");
        private static final Identifier GROUP_TWO = Identifier.fromNamespaceAndPath((String)"autoswitch", (String)"target_help_two");

        public void display(@NotNull DebugScreenDisplayer displayer, @Nullable Level level, @Nullable LevelChunk levelChunk, @Nullable LevelChunk levelChunk1) {
            SelectionContext context;
            if (level == null || Minecraft.getInstance().player == null || Minecraft.getInstance().hitResult == null) {
                return;
            }
            Map<Selector, Set<Selector>> selectors = Constants.CONFIG.getConfiguration().get((Object)this.action);
            switch (Objects.requireNonNull(Minecraft.getInstance().hitResult.getType())) {
                default: {
                    throw new MatchException(null, null);
                }
                case MISS: {
                    SelectionContext selectionContext = null;
                    break;
                }
                case BLOCK: {
                    HitResult block;
                    BlockHitResult result;
                    SelectionContext selectionContext;
                    HitResult hitResult = Minecraft.getInstance().hitResult;
                    if (hitResult instanceof BlockHitResult) {
                        result = (BlockHitResult)hitResult;
                        assert (Minecraft.getInstance().level != null);
                        block = Minecraft.getInstance().level.getBlockState(result.getBlockPos());
                        selectionContext = new SelectionContext(this.action, block);
                        break;
                    }
                    selectionContext = null;
                    break;
                }
                case ENTITY: {
                    BlockHitResult result;
                    SelectionContext selectionContext;
                    HitResult block = Minecraft.getInstance().hitResult;
                    if (block instanceof EntityHitResult) {
                        result = (EntityHitResult)block;
                        selectionContext = new SelectionContext(this.action, result.getEntity());
                        break;
                    }
                    selectionContext = context = null;
                }
            }
            if (context == null) {
                return;
            }
            List targets = selectors.keySet().stream().map(selector -> {
                Match m = selector.matches(context, context.target());
                return ObjectReferencePair.of((Object)selector, (Object)m);
            }).filter(p -> ((Match)p.right()).matches()).sorted((c2, c1) -> {
                int diff = Integer.compare(((Selector)c1.left()).priority(), ((Selector)c2.left()).priority());
                if (diff != 0) {
                    return diff;
                }
                int maxTargetRatingLevel = Math.max(((Match)c1.right()).getMaxLevel(), ((Match)c2.right()).getMaxLevel());
                for (int i = 0; i <= maxTargetRatingLevel; ++i) {
                    double r2;
                    double r1 = ((Match)c1.right()).getRating(i);
                    diff = Double.compare(r1, r2 = ((Match)c2.right()).getRating(i));
                    if (diff == 0) continue;
                    return diff;
                }
                return 0;
            }).map(Pair::left).map(s -> Matcher.prettyPrint(s.matcher())).flatMap(String::lines).toList();
            if (targets.isEmpty()) {
                return;
            }
            Identifier group = switch (this.action) {
                case Action.ATTACK -> GROUP_TWO;
                case Action.INTERACT -> GROUP_ONE;
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.action));
            };
            displayer.addToGroup(group, "Matched Targets for %s:".formatted(this.action.name()));
            for (String target : targets) {
                displayer.addToGroup(group, target);
            }
        }
    }

    private record ToolSelectorHelp() implements DebugScreenEntry
    {
        private static final Identifier GROUP_ONE = Identifier.fromNamespaceAndPath((String)"autoswitch", (String)"item_selector_help_one");

        public void display(@NotNull DebugScreenDisplayer displayer, @Nullable Level level, @Nullable LevelChunk levelChunk, @Nullable LevelChunk levelChunk1) {
            if (level == null || Minecraft.getInstance().player == null) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            ItemStack heldItem = player.getMainHandItem();
            SelectionContext context = new SelectionContext(Action.INTERACT, heldItem);
            List selectors = Constants.CONFIG.getConfiguration().values().stream().flatMap(s -> s.values().stream()).flatMap(Collection::stream).map(selector -> {
                Match m = selector.matches(context, context.target());
                return ObjectReferencePair.of((Object)selector, (Object)m);
            }).filter(p -> ((Match)p.right()).matches()).sorted((c2, c1) -> {
                int diff = 0;
                int maxToolRatingLevel = Math.max(((Match)c1.right()).getMaxLevel(), ((Match)c2.right()).getMaxLevel());
                for (int i = 0; i <= maxToolRatingLevel; ++i) {
                    double r2;
                    double r1 = ((Match)c1.right()).getRating(i);
                    diff = Double.compare(r1, r2 = ((Match)c2.right()).getRating(i));
                    if (diff == 0) continue;
                    return diff;
                }
                return 0;
            }).map(Pair::left).map(Selector::matcher).distinct().map(Matcher::prettyPrint).flatMap(String::lines).toList();
            if (selectors.isEmpty()) {
                return;
            }
            displayer.addToGroup(GROUP_ONE, "Matched Tool Selectors for Held Item");
            for (String target : selectors) {
                displayer.addToGroup(GROUP_ONE, target);
            }
        }
    }

    private record ItemTagHelp() implements DebugScreenEntry
    {
        private static final Identifier GROUP_ONE = Identifier.fromNamespaceAndPath((String)"autoswitch", (String)"item_tag_help_one");

        public void display(@NotNull DebugScreenDisplayer displayer, @Nullable Level level, @Nullable LevelChunk levelChunk, @Nullable LevelChunk levelChunk1) {
            if (level == null || Minecraft.getInstance().player == null) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            ItemStack heldItem = player.getMainHandItem();
            displayer.addToGroup(GROUP_ONE, "Held Item Tags:");
            heldItem.getTags().forEach(tag -> displayer.addToGroup(GROUP_ONE, "#" + String.valueOf(tag.location())));
        }
    }

    private record EntityTagHelp() implements DebugScreenEntry
    {
        private static final Identifier GROUP_ONE = Identifier.fromNamespaceAndPath((String)"autoswitch", (String)"entity_tag_help_one");

        public void display(@NotNull DebugScreenDisplayer displayer, @Nullable Level level, @Nullable LevelChunk levelChunk, @Nullable LevelChunk levelChunk1) {
            if (level == null || Minecraft.getInstance().player == null) {
                return;
            }
            HitResult hitResult = Minecraft.getInstance().hitResult;
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult result = (EntityHitResult)hitResult;
                displayer.addToGroup(GROUP_ONE, "Targeted Entity Tags:");
                result.getEntity().getType().builtInRegistryHolder().tags().forEach(tag -> displayer.addToGroup(GROUP_ONE, "#" + String.valueOf(tag.location())));
            }
        }
    }
}

