/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.data;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.DoubleSupplier;
import org.jetbrains.annotations.NotNull;

public record Match(boolean matches, Map<Integer, Set<DoubleSupplier>> ratings) {
    public Match(boolean matches) {
        this(matches, new HashMap<Integer, Set<DoubleSupplier>>());
    }

    public Match {
        if (ratings == null) {
            ratings = new HashMap<Integer, Set<DoubleSupplier>>();
        }
    }

    public void addRating(int level, DoubleSupplier rating) {
        Set<DoubleSupplier> l;
        if (!(rating instanceof MemoizedDoubleSupplier)) {
            rating = new MemoizedDoubleSupplier(rating);
        }
        if ((l = this.ratings.get(level)) != null) {
            l.add(rating);
        } else {
            HashSet<DoubleSupplier> s = new HashSet<DoubleSupplier>();
            s.add(rating);
            this.ratings.put(level, s);
        }
    }

    public void addRating(int level, Set<DoubleSupplier> rating) {
        this.ratings.merge(level, rating, (a, b) -> {
            a.addAll(b);
            return a;
        });
    }

    public double getRating(int level) {
        Set<DoubleSupplier> rating = this.ratings.get(level);
        if (rating != null && !rating.isEmpty()) {
            return rating.stream().mapToDouble(DoubleSupplier::getAsDouble).sum();
        }
        return 0.0;
    }

    public int getMaxLevel() {
        return this.ratings.keySet().stream().max(Comparator.naturalOrder()).orElse(0);
    }

    public void merge(Match match) {
        if (match.matches) {
            for (Map.Entry<Integer, Set<DoubleSupplier>> entry : match.ratings.entrySet()) {
                this.addRating((int)entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    @NotNull
    public String toString() {
        double[] r = new double[this.getMaxLevel() + 1];
        for (int i = 0; i <= this.getMaxLevel(); ++i) {
            r[i] = this.getRating(i);
        }
        return "Match{matches=" + this.matches + ", ratings=" + Arrays.toString(r) + "}";
    }

    private static class MemoizedDoubleSupplier
    implements DoubleSupplier {
        private final DoubleSupplier supplier;
        private volatile boolean done;
        private double value;

        public MemoizedDoubleSupplier(DoubleSupplier supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getAsDouble() {
            if (!this.done) {
                MemoizedDoubleSupplier memoizedDoubleSupplier = this;
                synchronized (memoizedDoubleSupplier) {
                    if (!this.done) {
                        this.value = this.supplier.getAsDouble();
                        this.done = true;
                    }
                }
            }
            return this.value;
        }
    }
}

