/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.types;

import dex.autoswitch.config.subentries.FeatureConfig;
import dex.autoswitch.engine.data.Match;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.data.extensible.PlayerInventory;
import dex.autoswitch.engine.state.SwitchContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetHeldSlotPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record SwitchedPlayer(Player player) implements PlayerInventory<ItemStack>
{
    @Override
    public void selectSlot(int slot) {
        this.player.getInventory().setSelectedSlot(slot);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send((Packet)new ClientboundSetHeldSlotPacket(slot));
        }
    }

    @Override
    public int currentSelectedSlot() {
        return this.player.getInventory().getSelectedSlot();
    }

    @Override
    public int slotCount() {
        return Inventory.getSelectionSize();
    }

    @Override
    public ItemStack getTool(int slot) {
        return this.player.getInventory().getItem(slot);
    }

    @Override
    public boolean canSwitchBack(SwitchContext ctx) {
        MultiPlayerGameMode gm = Minecraft.getInstance().gameMode;
        if (gm == null) {
            return false;
        }
        return !gm.isDestroying() && !this.player.isUsingItem() && (!this.waitForAttackProgress(ctx) || this.player.getAttackStrengthScale(-20.0f) == 1.0f) && !this.player.swinging;
    }

    @Override
    public void moveOffhand() {
        ClientPacketListener con;
        Minecraft mc = Minecraft.getInstance();
        if (mc != null && (con = mc.getConnection()) != null) {
            con.send((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.ZERO, Direction.DOWN));
        }
    }

    private boolean waitForAttackProgress(SwitchContext ctx) {
        if (this.player.getMainHandItem() == ItemStack.EMPTY) {
            return false;
        }
        for (FeatureConfig.SwitchbackSelector selector : ctx.config().featureConfig.switchbackWaitsForAttackProgress) {
            SelectionContext c;
            Match m;
            if (selector.action != ctx.action() || !(m = selector.target.matches(0, c = new SelectionContext(ctx.action(), ctx.target()), ctx.target())).matches()) continue;
            return true;
        }
        return false;
    }
}

