/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.types.selectable;

import dex.autoswitch.engine.TargetType;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.types.selectable.SelectableResource;
import dex.autoswitch.futures.FutureSelectable;
import dex.autoswitch.platform.Services;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockSelectableType
extends SelectableResource<Block> {
    public static final BlockSelectableType INSTANCE = new BlockSelectableType();

    private BlockSelectableType() {
        super("block");
    }

    @Override
    public Holder<Block> lookup(Identifier Identifier2) {
        return BuiltInRegistries.BLOCK.get(Identifier2).orElse(null);
    }

    @Override
    public TagKey<Block> lookupGroup(Identifier Identifier2) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (Identifier)Identifier2);
    }

    @Override
    public boolean matches(SelectionContext context, Holder<Block> v, Object selectable) {
        Block refBlock = (Block)v.value();
        if (selectable instanceof BlockState) {
            BlockState state = (BlockState)selectable;
            return refBlock.equals(state.getBlock());
        }
        if (selectable instanceof Block) {
            Block block = (Block)selectable;
            return refBlock.equals(block);
        }
        return false;
    }

    @Override
    public boolean matchesGroup(SelectionContext context, TagKey<Block> blockTagKey, Object selectable) {
        if (selectable instanceof BlockState) {
            BlockState state = (BlockState)selectable;
            return Services.PLATFORM.isInTag(blockTagKey, state.getBlock());
        }
        if (selectable instanceof Block) {
            Block block = (Block)selectable;
            return Services.PLATFORM.isInTag(blockTagKey, block);
        }
        return false;
    }

    @Override
    @Nullable
    public TargetType targetType() {
        return TargetType.BLOCKS;
    }

    @Override
    public boolean isOf(Object o) {
        Holder h;
        return o instanceof BlockState || o instanceof Block || o instanceof Holder && (h = (Holder)o).value() instanceof Block;
    }

    @Override
    public double typeRating(SelectionContext context, FutureSelectable<Identifier, Holder<Block>> futureValue, Object selectable) {
        return 0.0;
    }
}

