/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.types.selectable;

import dex.autoswitch.engine.TargetType;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.types.selectable.SelectableResource;
import dex.autoswitch.futures.FutureSelectable;
import dex.autoswitch.futures.FutureSelectableGroup;
import dex.autoswitch.futures.FutureSelectableValue;
import dex.autoswitch.platform.Services;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public class EnchantmentSelectableType
extends SelectableResource<Enchantment> {
    public static final EnchantmentSelectableType INSTANCE = new EnchantmentSelectableType();

    private EnchantmentSelectableType() {
        super("enchantment");
    }

    @Override
    public Holder<Enchantment> lookup(Identifier Identifier2) {
        Optional entry;
        Optional maybeReg = Services.PLATFORM.getRegistryAccess().lookup(Registries.ENCHANTMENT);
        if (maybeReg.isPresent() && (entry = ((Registry)maybeReg.get()).get(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (Identifier)Identifier2))).isPresent()) {
            return (Holder)entry.get();
        }
        return null;
    }

    @Override
    public TagKey<Enchantment> lookupGroup(Identifier Identifier2) {
        return TagKey.create((ResourceKey)Registries.ENCHANTMENT, (Identifier)Identifier2);
    }

    @Override
    public boolean matches(SelectionContext context, Holder<Enchantment> v, Object selectable) {
        ItemStack stack;
        if (selectable instanceof ItemStack && (stack = (ItemStack)selectable).isEnchanted()) {
            for (Holder holder : stack.getEnchantments().keySet()) {
                if (!holder.is(v)) continue;
                return true;
            }
        }
        if (selectable instanceof Enchantment) {
            Enchantment enchantment = (Enchantment)selectable;
            return enchantment.equals(v.value());
        }
        return false;
    }

    @Override
    public boolean matchesGroup(SelectionContext context, TagKey<Enchantment> enchantmentTagKey, Object selectable) {
        ItemStack stack;
        if (selectable instanceof ItemStack && (stack = (ItemStack)selectable).isEnchanted()) {
            for (Holder holder : stack.getEnchantments().keySet()) {
                if (!Services.PLATFORM.isInTag(enchantmentTagKey, (Enchantment)holder.value())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public TargetType targetType() {
        return null;
    }

    @Override
    public boolean isOf(Object o) {
        Holder h;
        return o instanceof Enchantment || o instanceof Holder && (h = (Holder)o).value() instanceof Enchantment;
    }

    @Override
    public double typeRating(SelectionContext context, FutureSelectable<Identifier, Holder<Enchantment>> futureValue, Object selectable) {
        ItemStack stack;
        if (selectable instanceof ItemStack && (stack = (ItemStack)selectable).isEnchanted()) {
            ItemEnchantments enchantments = stack.getEnchantments();
            FutureSelectable<Identifier, Holder<Enchantment>> futureSelectable = futureValue;
            Objects.requireNonNull(futureSelectable);
            FutureSelectable<Identifier, Holder<Enchantment>> futureSelectable2 = futureSelectable;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FutureSelectableGroup.class, FutureSelectableValue.class}, futureSelectable2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    FutureSelectableGroup v = (FutureSelectableGroup)futureSelectable2;
                    double d = 0.0;
                    int c = 0;
                    for (Holder holder : enchantments.keySet()) {
                        if (!Services.PLATFORM.isInTag((TagKey)v.getGroup(), (Enchantment)holder.value())) continue;
                        d += (double)enchantments.getLevel(holder) / (double)((Enchantment)holder.value()).getMaxLevel();
                        ++c;
                    }
                    if (c == 0) {
                        yield 0.0;
                    }
                    yield d / (double)c;
                }
                case 1 -> {
                    FutureSelectableValue enchantment = (FutureSelectableValue)futureSelectable2;
                    yield (double)enchantments.getLevel((Holder)enchantment.getValue()) / (double)((Enchantment)((Holder)enchantment.getValue()).value()).getMaxLevel();
                }
            };
        }
        return 0.0;
    }
}

