/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.types.selectable;

import dex.autoswitch.engine.TargetType;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.data.extensible.SelectableType;
import dex.autoswitch.futures.FutureSelectable;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import org.jetbrains.annotations.Nullable;

public class StatSelectableType
extends SelectableType<Identifier, Stat<?>, Void> {
    public static final StatSelectableType INSTANCE = new StatSelectableType();

    protected StatSelectableType() {
        super("stat");
    }

    @Override
    public Stat<?> lookup(Identifier Identifier2) {
        Identifier statType = Identifier.bySeparator((String)Identifier2.getNamespace(), (char)'.');
        Identifier statName = Identifier.bySeparator((String)Identifier2.getPath(), (char)'.');
        Optional stat = BuiltInRegistries.STAT_TYPE.getOptional(statType).flatMap(type -> StatSelectableType.getStat(type, statName));
        return stat.orElse(null);
    }

    private static <T> Optional<Stat<?>> getStat(StatType<T> statType, Identifier Identifier2) {
        return statType.getRegistry().getOptional(Identifier2).map(arg_0 -> statType.get(arg_0));
    }

    @Override
    public Void lookupGroup(Identifier Identifier2) {
        return null;
    }

    @Override
    public boolean matches(SelectionContext context, Stat<?> v, Object selectable) {
        if (selectable instanceof Stat) {
            Stat stat = (Stat)selectable;
            return v.equals((Object)stat);
        }
        return false;
    }

    @Override
    public boolean matchesGroup(SelectionContext context, Void statTagKey, Object selectable) {
        return false;
    }

    @Override
    @Nullable
    public TargetType targetType() {
        return TargetType.EVENTS;
    }

    @Override
    public boolean isOf(Object o) {
        return o instanceof Stat;
    }

    @Override
    public double typeRating(SelectionContext context, FutureSelectable<Identifier, Stat<?>> futureValue, Object selectable) {
        return 0.0;
    }

    @Override
    public String serializeKey(Identifier Identifier2) {
        return Identifier2.toString();
    }

    @Override
    public Identifier deserializeKey(String key) {
        Identifier id = Identifier.tryParse((String)key);
        if (id != null) {
            return id;
        }
        throw new NullPointerException("Invalid Identifier: " + key);
    }
}

