/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.config.transformations;

import dex.autoswitch.engine.Action;
import dex.lib.io.leangen.geantyref.TypeToken;
import dex.lib.org.spongepowered.configurate.ConfigurateException;
import dex.lib.org.spongepowered.configurate.ConfigurationNode;
import dex.lib.org.spongepowered.configurate.NodePath;
import dex.lib.org.spongepowered.configurate.transformation.ConfigurationTransformation;
import java.util.Set;
import java.util.logging.Logger;

public final class Transformations {
    private static final Logger LOGGER = Logger.getLogger("AutoSwitch Config");
    private static final int VERSION_LATEST = 2;

    private Transformations() {
    }

    public static ConfigurationTransformation.Versioned create() {
        return ConfigurationTransformation.versionedBuilder().versionKey("config-version").addVersion(2, Transformations.initialTransform()).build();
    }

    public static <N extends ConfigurationNode> N updateNode(N node) throws ConfigurateException {
        if (!node.virtual()) {
            ConfigurationTransformation.Versioned trans = Transformations.create();
            int startVersion = trans.version(node);
            trans.apply(node);
            int endVersion = trans.version(node);
            if (startVersion != endVersion) {
                LOGGER.info("Updated config schema from " + startVersion + " to " + endVersion);
            }
        }
        return node;
    }

    public static ConfigurationTransformation initialTransform() {
        return ConfigurationTransformation.builder().addAction(NodePath.path("feature-config", "switch-away-from-tools"), (path, value) -> {
            if (value.getBoolean(true)) {
                value.set(new TypeToken<Set<Action>>(){}, Set.of(Action.ATTACK));
            } else {
                value.set(new TypeToken<Set<Action>>(){}, Set.of());
            }
            return null;
        }).build();
    }
}

