/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.debug.gui;

import dex.autoswitch.Constants;
import dex.autoswitch.engine.Action;
import dex.autoswitch.engine.Matcher;
import dex.autoswitch.engine.Selector;
import dex.autoswitch.engine.data.Match;
import dex.autoswitch.engine.data.SelectionContext;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectReferencePair;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_11630;
import net.minecraft.class_11632;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9336;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugText {
    public static void register(BiConsumer<class_2960, class_11632> consumer) {
        DebugText.register(consumer, "enchantments", new EnchantmentHelp(false));
        DebugText.register(consumer, "enchantment_tags", new EnchantmentHelp(true));
        DebugText.register(consumer, "item_components", new ItemComponentHelp());
        DebugText.register(consumer, "attack_targets", new TargetHelp(Action.ATTACK));
        DebugText.register(consumer, "interact_targets", new TargetHelp(Action.INTERACT));
        DebugText.register(consumer, "tool_selectors", new ToolSelectorHelp());
        DebugText.register(consumer, "item_tags", new ItemTagHelp());
        DebugText.register(consumer, "entity_tags", new EntityTagHelp());
    }

    private static void register(BiConsumer<class_2960, class_11632> consumer, String id, class_11632 entry) {
        consumer.accept(class_2960.method_60655((String)"autoswitch", (String)id), entry);
    }

    private record EnchantmentHelp(boolean showTags) implements class_11632
    {
        private static final class_2960 GROUP_ONE = class_2960.method_60655((String)"autoswitch", (String)"enchantment_help_one");
        private static final class_2960 GROUP_TWO = class_2960.method_60655((String)"autoswitch", (String)"enchantment_help_two");

        public void method_72751(@NotNull class_11630 displayer, @Nullable class_1937 level, @Nullable class_2818 levelChunk, @Nullable class_2818 levelChunk1) {
            if (level == null || class_310.method_1551().field_1724 == null) {
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            class_1799 heldItem = player.method_6047();
            if (heldItem.method_7942()) {
                displayer.method_72743(this.showTags ? GROUP_TWO : GROUP_ONE, "Held Item Enchantments:");
                class_9304 enchantments = heldItem.method_58657();
                for (class_6880 enchantment : enchantments.method_57534()) {
                    if (this.showTags) {
                        enchantment.method_40228().forEach(tag -> displayer.method_72743(GROUP_TWO, "#" + String.valueOf(tag.comp_327())));
                        continue;
                    }
                    displayer.method_72743(GROUP_ONE, enchantment.method_55840());
                }
            }
        }
    }

    private record ItemComponentHelp() implements class_11632
    {
        private static final class_2960 GROUP_ONE = class_2960.method_60655((String)"autoswitch", (String)"component_help_one");

        public void method_72751(@NotNull class_11630 displayer, @Nullable class_1937 level, @Nullable class_2818 levelChunk, @Nullable class_2818 levelChunk1) {
            if (level == null || class_310.method_1551().field_1724 == null) {
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            class_1799 heldItem = player.method_6047();
            class_9323 components = heldItem.method_57353();
            if (components.method_57832(class_9334.field_49651)) {
                displayer.method_72743(GROUP_ONE, "Held Item Potion Contents:");
                class_9336 pc = components.method_66876(class_9334.field_49651);
                if (pc == null) {
                    return;
                }
                displayer.method_72743(GROUP_ONE, ((class_1844)pc.comp_2444()).comp_2378().map(class_6880::method_55840).orElse("unknown"));
            }
        }
    }

    private record TargetHelp(Action action) implements class_11632
    {
        private static final class_2960 GROUP_ONE = class_2960.method_60655((String)"autoswitch", (String)"target_help_one");
        private static final class_2960 GROUP_TWO = class_2960.method_60655((String)"autoswitch", (String)"target_help_two");

        public void method_72751(@NotNull class_11630 displayer, @Nullable class_1937 level, @Nullable class_2818 levelChunk, @Nullable class_2818 levelChunk1) {
            SelectionContext context;
            if (level == null || class_310.method_1551().field_1724 == null || class_310.method_1551().field_1765 == null) {
                return;
            }
            Map<Selector, Set<Selector>> selectors = Constants.CONFIG.getConfiguration().get((Object)this.action);
            switch (Objects.requireNonNull(class_310.method_1551().field_1765.method_17783())) {
                default: {
                    throw new MatchException(null, null);
                }
                case field_1333: {
                    SelectionContext selectionContext = null;
                    break;
                }
                case field_1332: {
                    class_239 block;
                    class_3965 result;
                    SelectionContext selectionContext;
                    class_239 class_2392 = class_310.method_1551().field_1765;
                    if (class_2392 instanceof class_3965) {
                        result = (class_3965)class_2392;
                        assert (class_310.method_1551().field_1687 != null);
                        block = class_310.method_1551().field_1687.method_8320(result.method_17777());
                        selectionContext = new SelectionContext(this.action, block);
                        break;
                    }
                    selectionContext = null;
                    break;
                }
                case field_1331: {
                    class_3965 result;
                    SelectionContext selectionContext;
                    class_239 block = class_310.method_1551().field_1765;
                    if (block instanceof class_3966) {
                        result = (class_3966)block;
                        selectionContext = new SelectionContext(this.action, result.method_17782());
                        break;
                    }
                    selectionContext = context = null;
                }
            }
            if (context == null) {
                return;
            }
            List targets = selectors.keySet().stream().map(selector -> {
                Match m = selector.matches(context, context.target());
                return ObjectReferencePair.of((Object)selector, (Object)m);
            }).filter(p -> ((Match)p.right()).matches()).sorted((c2, c1) -> {
                int diff = Integer.compare(((Selector)c1.left()).priority(), ((Selector)c2.left()).priority());
                if (diff != 0) {
                    return diff;
                }
                int maxTargetRatingLevel = Math.max(((Match)c1.right()).getMaxLevel(), ((Match)c2.right()).getMaxLevel());
                for (int i = 0; i <= maxTargetRatingLevel; ++i) {
                    double r2;
                    double r1 = ((Match)c1.right()).getRating(i);
                    diff = Double.compare(r1, r2 = ((Match)c2.right()).getRating(i));
                    if (diff == 0) continue;
                    return diff;
                }
                return 0;
            }).map(Pair::left).map(s -> Matcher.prettyPrint(s.matcher())).flatMap(String::lines).toList();
            if (targets.isEmpty()) {
                return;
            }
            class_2960 group = switch (this.action) {
                case Action.ATTACK -> GROUP_TWO;
                case Action.INTERACT -> GROUP_ONE;
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.action));
            };
            displayer.method_72743(group, "Matched Targets for %s:".formatted(this.action.name()));
            for (String target : targets) {
                displayer.method_72743(group, target);
            }
        }
    }

    private record ToolSelectorHelp() implements class_11632
    {
        private static final class_2960 GROUP_ONE = class_2960.method_60655((String)"autoswitch", (String)"item_selector_help_one");

        public void method_72751(@NotNull class_11630 displayer, @Nullable class_1937 level, @Nullable class_2818 levelChunk, @Nullable class_2818 levelChunk1) {
            if (level == null || class_310.method_1551().field_1724 == null) {
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            class_1799 heldItem = player.method_6047();
            SelectionContext context = new SelectionContext(Action.INTERACT, heldItem);
            List selectors = Constants.CONFIG.getConfiguration().values().stream().flatMap(s -> s.values().stream()).flatMap(Collection::stream).map(selector -> {
                Match m = selector.matches(context, context.target());
                return ObjectReferencePair.of((Object)selector, (Object)m);
            }).filter(p -> ((Match)p.right()).matches()).sorted((c2, c1) -> {
                int diff = 0;
                int maxToolRatingLevel = Math.max(((Match)c1.right()).getMaxLevel(), ((Match)c2.right()).getMaxLevel());
                for (int i = 0; i <= maxToolRatingLevel; ++i) {
                    double r2;
                    double r1 = ((Match)c1.right()).getRating(i);
                    diff = Double.compare(r1, r2 = ((Match)c2.right()).getRating(i));
                    if (diff == 0) continue;
                    return diff;
                }
                return 0;
            }).map(Pair::left).map(Selector::matcher).distinct().map(Matcher::prettyPrint).flatMap(String::lines).toList();
            if (selectors.isEmpty()) {
                return;
            }
            displayer.method_72743(GROUP_ONE, "Matched Tool Selectors for Held Item");
            for (String target : selectors) {
                displayer.method_72743(GROUP_ONE, target);
            }
        }
    }

    private record ItemTagHelp() implements class_11632
    {
        private static final class_2960 GROUP_ONE = class_2960.method_60655((String)"autoswitch", (String)"item_tag_help_one");

        public void method_72751(@NotNull class_11630 displayer, @Nullable class_1937 level, @Nullable class_2818 levelChunk, @Nullable class_2818 levelChunk1) {
            if (level == null || class_310.method_1551().field_1724 == null) {
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            class_1799 heldItem = player.method_6047();
            displayer.method_72743(GROUP_ONE, "Held Item Tags:");
            heldItem.method_40133().forEach(tag -> displayer.method_72743(GROUP_ONE, "#" + String.valueOf(tag.comp_327())));
        }
    }

    private record EntityTagHelp() implements class_11632
    {
        private static final class_2960 GROUP_ONE = class_2960.method_60655((String)"autoswitch", (String)"entity_tag_help_one");

        public void method_72751(@NotNull class_11630 displayer, @Nullable class_1937 level, @Nullable class_2818 levelChunk, @Nullable class_2818 levelChunk1) {
            if (level == null || class_310.method_1551().field_1724 == null) {
                return;
            }
            class_239 class_2392 = class_310.method_1551().field_1765;
            if (class_2392 instanceof class_3966) {
                class_3966 result = (class_3966)class_2392;
                displayer.method_72743(GROUP_ONE, "Targeted Entity Tags:");
                result.method_17782().method_5864().method_40124().method_40228().forEach(tag -> displayer.method_72743(GROUP_ONE, "#" + String.valueOf(tag.comp_327())));
            }
        }
    }
}

