/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.events;

import dex.autoswitch.engine.events.SwitchEvent;
import dex.autoswitch.engine.state.SwitchContext;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Logger;

public class Scheduler {
    private static final int QUEUE_SIZE_WARNING_THRESHOLD = 64;
    private static final Logger LOGGER = Logger.getLogger("AutoSwitch-Engine");
    private final Object lock = new Object();
    private final Map<SwitchEvent, Task> taskMap = new EnumMap<SwitchEvent, Task>(SwitchEvent.class);
    private int tickTime;

    public void schedule(SwitchEvent event, SwitchContext context, int deltaTicks) {
        this.schedule(event, context, deltaTicks, this.tickTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule(SwitchEvent event, SwitchContext context, int deltaTicks, int initTickTime) {
        int scheduledTick = initTickTime + deltaTicks;
        Object object = this.lock;
        synchronized (object) {
            Task task = new Task(event, context, scheduledTick);
            this.taskMap.put(event, task);
        }
    }

    public void tick() {
        this.execute(this.tickTime++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(int currentTick) {
        Object object = this.lock;
        synchronized (object) {
            this.taskMap.values().removeIf(task -> task.finalTickTime <= currentTick && task.event.perform(task.context));
        }
        this.resetTickIfLargeTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.taskMap.clear();
            this.tickTime = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEventScheduled(SwitchEvent event) {
        Object object = this.lock;
        synchronized (object) {
            return this.taskMap.containsKey((Object)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTickIfLargeTime() {
        Object object = this.lock;
        synchronized (object) {
            if (this.taskMap.isEmpty() && this.tickTime >= 0x3FFFFFFF) {
                this.tickTime = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(SwitchEvent event) {
        Object object = this.lock;
        synchronized (object) {
            this.taskMap.remove((Object)event);
        }
    }

    private record Task(SwitchEvent event, SwitchContext context, int finalTickTime) {
    }
}

