/*
 * Decompiled with CFR 0.152.
 */
package dex.lib.org.spongepowered.configurate;

import dex.lib.io.leangen.geantyref.GenericTypeReflector;
import dex.lib.org.spongepowered.configurate.ConfigValue;
import dex.lib.org.spongepowered.configurate.ConfigurateException;
import dex.lib.org.spongepowered.configurate.ConfigurationNode;
import dex.lib.org.spongepowered.configurate.ConfigurationOptions;
import dex.lib.org.spongepowered.configurate.ConfigurationVisitor;
import dex.lib.org.spongepowered.configurate.ListConfigValue;
import dex.lib.org.spongepowered.configurate.MapConfigValue;
import dex.lib.org.spongepowered.configurate.NodePath;
import dex.lib.org.spongepowered.configurate.NullConfigValue;
import dex.lib.org.spongepowered.configurate.RepresentationHint;
import dex.lib.org.spongepowered.configurate.ScalarConfigValue;
import dex.lib.org.spongepowered.configurate.ScopedConfigurationNode;
import dex.lib.org.spongepowered.configurate.VisitorNodeEnd;
import dex.lib.org.spongepowered.configurate.VisitorSafeNoopException;
import dex.lib.org.spongepowered.configurate.serialize.SerializationException;
import dex.lib.org.spongepowered.configurate.serialize.TypeSerializer;
import dex.lib.org.spongepowered.configurate.util.UnmodifiableCollections;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractConfigurationNode<N extends ScopedConfigurationNode<N>, A extends AbstractConfigurationNode<N, A>>
implements ScopedConfigurationNode<N> {
    private final ConfigurationOptions options;
    volatile boolean attached;
    volatile @Nullable Object key;
    private @Nullable A parent;
    volatile ConfigValue<N, A> value;
    final Map<RepresentationHint<?>, Object> hints;

    protected AbstractConfigurationNode(@Nullable Object key, @Nullable A parent, ConfigurationOptions options) {
        Objects.requireNonNull(options, "options");
        if (key == null != (parent == null)) {
            throw new IllegalArgumentException("A node's key and parent must share the same nullability status");
        }
        this.key = key;
        this.options = options;
        this.parent = parent;
        this.value = NullConfigValue.instance();
        this.hints = new ConcurrentHashMap();
        if (parent == null) {
            this.attached = true;
        }
    }

    protected AbstractConfigurationNode(@Nullable A parent, A copyOf) {
        this.options = ((AbstractConfigurationNode)copyOf).options();
        this.attached = true;
        this.key = ((AbstractConfigurationNode)copyOf).key;
        this.parent = parent;
        this.value = ((AbstractConfigurationNode)copyOf).value.copy(this.implSelf());
        this.hints = new ConcurrentHashMap(((AbstractConfigurationNode)copyOf).hints);
    }

    static <V> V storeDefault(ConfigurationNode node, Type type, V defValue) throws SerializationException {
        Objects.requireNonNull(defValue, "defValue");
        if (node.options().shouldCopyDefaults()) {
            node.set(type, defValue);
        }
        return defValue;
    }

    static <V> V storeDefault(ConfigurationNode node, AnnotatedType type, V defValue) throws SerializationException {
        Objects.requireNonNull(defValue, "defValue");
        if (node.options().shouldCopyDefaults()) {
            node.set(type, defValue);
        }
        return defValue;
    }

    @Override
    public final @Nullable Object get(AnnotatedType type) throws SerializationException {
        return this.get0(type, true);
    }

    @Override
    public final Object get(AnnotatedType type, Object def) throws SerializationException {
        @Nullable Object value = this.get0(type, false);
        return value == null ? AbstractConfigurationNode.storeDefault((ConfigurationNode)this, type, def) : value;
    }

    @Override
    public final Object get(AnnotatedType type, Supplier<?> defSupplier) throws SerializationException {
        @Nullable Object value = this.get0(type, false);
        return value == null ? AbstractConfigurationNode.storeDefault((ConfigurationNode)this, type, defSupplier.get()) : value;
    }

    @Override
    public final @Nullable Object get(Type type) throws SerializationException {
        return this.get0(type, true);
    }

    @Override
    public final Object get(Type type, Object def) throws SerializationException {
        @Nullable Object value = this.get0(type, false);
        return value == null ? AbstractConfigurationNode.storeDefault((ConfigurationNode)this, type, def) : value;
    }

    @Override
    public final Object get(Type type, Supplier<?> defSupplier) throws SerializationException {
        @Nullable Object value = this.get0(type, false);
        return value == null ? AbstractConfigurationNode.storeDefault((ConfigurationNode)this, type, defSupplier.get()) : value;
    }

    final @Nullable Object get0(Type type, boolean doImplicitInit) throws SerializationException {
        Objects.requireNonNull(type, "type");
        if (GenericTypeReflector.isMissingTypeParameters(type)) {
            throw new SerializationException((ConfigurationNode)this, type, "Raw types are not supported");
        }
        @Nullable TypeSerializer<?> serial = this.options().serializers().get(type);
        if (this.value instanceof NullConfigValue) {
            Object emptyValue;
            if (serial != null && doImplicitInit && this.options().implicitInitialization() && (emptyValue = serial.emptyValue(type, this.options)) != null) {
                return AbstractConfigurationNode.storeDefault((ConfigurationNode)this, type, emptyValue);
            }
            return null;
        }
        if (serial == null) {
            @Nullable Object value = this.raw();
            Class<?> erasure = GenericTypeReflector.erase(type);
            if (erasure.isInstance(value)) {
                return value;
            }
            return null;
        }
        try {
            return serial.deserialize(type, (ConfigurationNode)this.self());
        }
        catch (SerializationException ex) {
            ex.initPath(this::path);
            ex.initType(type);
            throw ex;
        }
    }

    final @Nullable Object get0(AnnotatedType type, boolean doImplicitInit) throws SerializationException {
        Objects.requireNonNull(type, "type");
        if (GenericTypeReflector.isMissingTypeParameters(type.getType())) {
            throw new SerializationException((ConfigurationNode)this, type, "Raw types are not supported");
        }
        @Nullable TypeSerializer<?> serial = this.options().serializers().get(type);
        if (this.value instanceof NullConfigValue) {
            Object emptyValue;
            if (serial != null && doImplicitInit && this.options().implicitInitialization() && (emptyValue = serial.emptyValue(type, this.options)) != null) {
                return AbstractConfigurationNode.storeDefault((ConfigurationNode)this, type, emptyValue);
            }
            return null;
        }
        if (serial == null) {
            @Nullable Object value = this.raw();
            Class<?> erasure = GenericTypeReflector.erase(type.getType());
            if (erasure.isInstance(value)) {
                return value;
            }
            return null;
        }
        try {
            return serial.deserialize(type, (ConfigurationNode)this);
        }
        catch (SerializationException ex) {
            ex.initPath(this::path);
            ex.initType(type);
            throw ex;
        }
    }

    @Override
    public final N set(@Nullable Object newValue) throws SerializationException {
        if (newValue instanceof ConfigurationNode) {
            this.from((ConfigurationNode)newValue);
            return this.self();
        }
        if (newValue == null) {
            @Nullable Object key = this.key;
            if (this.parent == null || key == null) {
                this.clear();
            } else {
                ((AbstractConfigurationNode)this.parent).removeChild(key);
            }
            return this.self();
        }
        if (newValue instanceof Collection || newValue instanceof Map) {
            this.insertNewValue(newValue, false);
            return this.self();
        }
        return (N)this.set((Type)newValue.getClass(), newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public N from(ConfigurationNode that) {
        if (that == this) {
            return this.self();
        }
        this.hints.clear();
        this.hints.putAll(that.ownHints());
        if (that.isList()) {
            this.attachIfNecessary();
            ListConfigValue newList = new ListConfigValue(this.implSelf());
            ConfigurationNode configurationNode = that;
            synchronized (configurationNode) {
                List<? extends ConfigurationNode> children = that.childrenList();
                for (int i = 0; i < children.size(); ++i) {
                    A node = this.createNode(i);
                    ((AbstractConfigurationNode)node).attached = true;
                    ((AbstractConfigurationNode)node).from(children.get(i));
                    newList.putChild(i, node);
                }
            }
            this.value = newList;
        } else if (that.isMap()) {
            this.attachIfNecessary();
            MapConfigValue newMap = new MapConfigValue(this.implSelf());
            ConfigurationNode configurationNode = that;
            synchronized (configurationNode) {
                for (Map.Entry<Object, ? extends ConfigurationNode> entry : that.childrenMap().entrySet()) {
                    A node = this.createNode(entry.getKey());
                    ((AbstractConfigurationNode)node).attached = true;
                    ((AbstractConfigurationNode)node).from(entry.getValue());
                    newMap.putChild(entry.getKey(), node);
                }
            }
            this.value = newMap;
        } else {
            this.raw(that.raw());
        }
        return this.self();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNewValue(Object newValue, boolean onlyIfNull) {
        if (newValue instanceof ConfigurationNode) {
            throw new IllegalArgumentException("Cannot set a node as the raw value of another node");
        }
        this.attachIfNecessary();
        AbstractConfigurationNode abstractConfigurationNode = this;
        synchronized (abstractConfigurationNode) {
            ConfigValue<N, A> value;
            ConfigValue<N, A> oldValue = value = this.value;
            if (onlyIfNull && !(oldValue instanceof NullConfigValue)) {
                return;
            }
            if (newValue instanceof Collection) {
                if (!(value instanceof ListConfigValue)) {
                    value = new ListConfigValue(this.implSelf());
                }
            } else if (newValue instanceof Map) {
                if (!(value instanceof MapConfigValue)) {
                    value = new MapConfigValue(this.implSelf());
                }
            } else if (!(value instanceof ScalarConfigValue)) {
                value = new ScalarConfigValue(this.implSelf());
            }
            value.set(newValue);
            this.value = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public N mergeFrom(ConfigurationNode other) {
        if ((this.virtual() || this.empty()) && !other.virtual()) {
            return (N)this.from(other);
        }
        this.hints.putAll(other.ownHints());
        if (other.isMap()) {
            AbstractConfigurationNode abstractConfigurationNode = this;
            synchronized (abstractConfigurationNode) {
                ConfigValue<N, A> newValue;
                ConfigValue<N, A> oldValue = newValue = this.value;
                if (!(oldValue instanceof MapConfigValue)) {
                    if (oldValue instanceof NullConfigValue) {
                        newValue = new MapConfigValue(this.implSelf());
                    } else {
                        return this.self();
                    }
                }
                for (Map.Entry<Object, ? extends ConfigurationNode> ent : other.childrenMap().entrySet()) {
                    @Nullable A currentChild = newValue.child(ent.getKey());
                    if (currentChild != null && ((AbstractConfigurationNode)currentChild).raw() != null && ent.getValue().raw() == null) continue;
                    A newChild = this.createNode(ent.getKey());
                    ((AbstractConfigurationNode)newChild).attached = true;
                    ((AbstractConfigurationNode)newChild).from(ent.getValue());
                    @Nullable A existing = newValue.putChildIfAbsent(ent.getKey(), newChild);
                    if (existing == null) continue;
                    ((AbstractConfigurationNode)existing).mergeFrom((ConfigurationNode)newChild);
                }
                this.value = newValue;
            }
        } else if (other.isList()) {
            if (this.virtual()) {
                this.from(other);
            }
        } else if (other.rawScalar() != null) {
            this.insertNewValue(other.rawScalar(), true);
        }
        return this.self();
    }

    @Override
    public final @Nullable Object raw() {
        return this.value.get();
    }

    @Override
    public final N raw(@Nullable Object newValue) {
        if (newValue == null) {
            @Nullable Object key = this.key;
            if (this.parent == null || key == null) {
                this.clear();
            } else {
                ((AbstractConfigurationNode)this.parent).removeChild(key);
            }
        } else {
            this.insertNewValue(newValue, false);
        }
        return this.self();
    }

    @Override
    public final @Nullable Object rawScalar() {
        ConfigValue<N, A> value = this.value;
        if (value instanceof ScalarConfigValue) {
            return value.get();
        }
        return null;
    }

    @Override
    public final N node(Object ... path) {
        A pointer = this.implSelf();
        for (Object el : path) {
            pointer = ((AbstractConfigurationNode)pointer).child(Objects.requireNonNull(el, () -> "element in path " + Arrays.toString(path)), false);
        }
        return pointer.self();
    }

    @Override
    public final N node(Iterable<?> path) {
        A pointer = this.implSelf();
        for (Object el : path) {
            pointer = ((AbstractConfigurationNode)pointer).child(Objects.requireNonNull(el, () -> "element in path " + path), false);
        }
        return pointer.self();
    }

    @Override
    public final boolean hasChild(Object ... path) {
        A pointer = this.implSelf();
        for (Object el : path) {
            @Nullable A child = ((AbstractConfigurationNode)pointer).value.child(Objects.requireNonNull(el, () -> "element in path " + Arrays.toString(path)));
            if (child == null) {
                return false;
            }
            pointer = child;
        }
        return true;
    }

    @Override
    public final boolean hasChild(Iterable<?> path) {
        A pointer = this.implSelf();
        for (Object el : path) {
            @Nullable A child = ((AbstractConfigurationNode)pointer).value.child(Objects.requireNonNull(el, () -> "element in path " + path));
            if (child == null) {
                return false;
            }
            pointer = child;
        }
        return true;
    }

    @Override
    public final boolean virtual() {
        return !this.attached;
    }

    @Override
    public boolean isNull() {
        return this.value instanceof NullConfigValue;
    }

    @Override
    public final boolean isList() {
        return this.value instanceof ListConfigValue;
    }

    @Override
    public final boolean isMap() {
        return this.value instanceof MapConfigValue;
    }

    @Override
    public final List<N> childrenList() {
        ConfigValue<N, A> value = this.value;
        return value instanceof ListConfigValue ? ((ListConfigValue)value).unwrapped() : Collections.emptyList();
    }

    @Override
    public final Map<Object, N> childrenMap() {
        ConfigValue<N, A> value = this.value;
        return value instanceof MapConfigValue ? ((MapConfigValue)value).unwrapped() : Collections.emptyMap();
    }

    @Override
    public boolean empty() {
        return this.value.isEmpty();
    }

    protected final A child(Object key, boolean attach) {
        @Nullable A child = this.value.child(key);
        if (child == null) {
            if (attach) {
                this.attachIfNecessary();
                child = this.createNode(key);
                @Nullable A existingChild = this.value.putChildIfAbsent(key, child);
                if (existingChild != null) {
                    child = existingChild;
                } else {
                    this.attachChild(child);
                }
            } else {
                child = this.createNode(key);
            }
        }
        return child;
    }

    @Override
    public final boolean removeChild(Object key) {
        return AbstractConfigurationNode.detachIfNonNull(this.value.putChild(key, null)) != null;
    }

    private static <N extends ScopedConfigurationNode<N>, T extends AbstractConfigurationNode<N, T>> @Nullable T detachIfNonNull(@Nullable T node) {
        if (node != null) {
            node.attached = false;
            node.clear();
        }
        return node;
    }

    @Override
    public final N appendListNode() {
        return this.child(ListConfigValue.UNALLOCATED_IDX, false).self();
    }

    @Override
    public final @Nullable Object key() {
        return this.key;
    }

    @Override
    public final NodePath path() {
        Object pointer = this.self();
        if (pointer.parent() == null) {
            return NodePath.path();
        }
        ArrayDeque<@Nullable Object> pathElements = new ArrayDeque<Object>();
        do {
            pathElements.addFirst(pointer.key());
        } while ((pointer = (ScopedConfigurationNode)Objects.requireNonNull(pointer.parent())).parent() != null);
        return NodePath.of(pathElements);
    }

    @Override
    public final @Nullable N parent() {
        @Nullable A parent = this.parent;
        return parent == null ? null : (N)parent.self();
    }

    @Override
    public final ConfigurationOptions options() {
        return this.options;
    }

    @Override
    public final N copy() {
        return this.copy(null).self();
    }

    protected abstract A copy(@Nullable A var1);

    final @Nullable A parentEnsureAttached() {
        @Nullable A parent = this.parent;
        if (parent != null && ((AbstractConfigurationNode)parent).virtual()) {
            parent = ((AbstractConfigurationNode)((AbstractConfigurationNode)parent).parentEnsureAttached()).attachChildIfAbsent(parent);
        }
        this.parent = parent;
        return this.parent;
    }

    protected final void attachIfNecessary() {
        A parent;
        if (!this.attached && (parent = this.parentEnsureAttached()) != null) {
            ((AbstractConfigurationNode)parent).attachChild(this.implSelf());
        }
    }

    protected final A attachChildIfAbsent(A child) {
        return this.attachChild(child, true);
    }

    final void attachChild(A child) {
        this.attachChild(child, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private A attachChild(A child, boolean onlyIfAbsent) {
        ConfigValue<N, A> newValue;
        ConfigValue<N, A> oldValue;
        if (this.virtual()) {
            throw new IllegalStateException("This parent is not currently attached. This is an internal state violation.");
        }
        if (!Objects.equals(((AbstractConfigurationNode)child).parentEnsureAttached(), this)) {
            throw new IllegalStateException("Child " + child + " path is not a direct parent of me (" + this.path() + "), cannot attach");
        }
        AbstractConfigurationNode abstractConfigurationNode = this;
        synchronized (abstractConfigurationNode) {
            Object childKey;
            newValue = oldValue = this.value;
            if (oldValue instanceof MapConfigValue) {
                if (((AbstractConfigurationNode)child).key == ListConfigValue.UNALLOCATED_IDX) {
                    newValue = new ListConfigValue(this.implSelf());
                }
            } else if (ListConfigValue.likelyNewListKey(((AbstractConfigurationNode)child).key) || ListConfigValue.likelyListKey(oldValue, ((AbstractConfigurationNode)child).key)) {
                if (oldValue instanceof NullConfigValue) {
                    newValue = new ListConfigValue(this.implSelf());
                } else if (!(oldValue instanceof ListConfigValue)) {
                    newValue = new ListConfigValue(this.implSelf(), oldValue.get());
                }
            } else {
                newValue = new MapConfigValue(this.implSelf());
            }
            if ((childKey = ((AbstractConfigurationNode)child).key) == null) {
                throw new IllegalArgumentException("Cannot attach a child with null key");
            }
            if (onlyIfAbsent) {
                @Nullable A oldChild = newValue.putChildIfAbsent(childKey, child);
                if (oldChild != null) {
                    return oldChild;
                }
            } else {
                AbstractConfigurationNode.detachIfNonNull(newValue.putChild(childKey, child));
            }
            this.value = newValue;
        }
        if (newValue != oldValue) {
            oldValue.clear();
        }
        ((AbstractConfigurationNode)child).attached = true;
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clear() {
        AbstractConfigurationNode abstractConfigurationNode = this;
        synchronized (abstractConfigurationNode) {
            ConfigValue<N, A> oldValue = this.value;
            this.value = NullConfigValue.instance();
            oldValue.clear();
        }
    }

    @Override
    public final <S, T, E extends Exception> T visit(ConfigurationVisitor<S, T, E> visitor, S state) throws E {
        return this.visitInternal(visitor, state);
    }

    @Override
    public final <S, T> T visit(ConfigurationVisitor.Safe<S, T> visitor, S state) {
        try {
            return this.visitInternal(visitor, state);
        }
        catch (VisitorSafeNoopException ex) {
            throw new AssertionError("Exception was thrown on a Safe visitor", ex);
        }
    }

    private <S, T, E extends Exception> T visitInternal(ConfigurationVisitor<S, T, E> visitor, S state) throws E {
        visitor.beginVisit((ConfigurationNode)this.self(), state);
        if (!(this.value instanceof NullConfigValue)) {
            Object active;
            LinkedList<Object> toVisit = new LinkedList<Object>();
            toVisit.add(this);
            while ((active = toVisit.pollFirst()) != null) {
                @Nullable A current = VisitorNodeEnd.popFromVisitor(active, visitor, state);
                if (current == null) continue;
                try {
                    visitor.enterNode((ConfigurationNode)current.self(), state);
                    ConfigValue<N, A> value = ((AbstractConfigurationNode)current).value;
                    if (value instanceof MapConfigValue) {
                        visitor.enterMappingNode((ConfigurationNode)current.self(), state);
                        toVisit.addFirst(new VisitorNodeEnd((ConfigurationNode)current, true));
                        toVisit.addAll(0, ((MapConfigValue)value).values.values());
                        continue;
                    }
                    if (value instanceof ListConfigValue) {
                        visitor.enterListNode((ConfigurationNode)current.self(), state);
                        toVisit.addFirst(new VisitorNodeEnd((ConfigurationNode)current, false));
                        toVisit.addAll(0, ((ListConfigValue)value).values);
                        continue;
                    }
                    if (value instanceof ScalarConfigValue) {
                        visitor.enterScalarNode((ConfigurationNode)current.self(), state);
                        continue;
                    }
                    if (value instanceof NullConfigValue) continue;
                    throw new IllegalStateException("Unknown value type " + value.getClass() + " at " + ((AbstractConfigurationNode)current).path());
                }
                catch (Exception ex) {
                    if (ex instanceof ConfigurateException) {
                        ((ConfigurateException)ex).initPath(() -> current.path());
                    }
                    throw ex;
                }
            }
        }
        return visitor.endVisit(state);
    }

    @Override
    public final <V> N hint(RepresentationHint<V> hint, @Nullable V value) {
        if (value == null) {
            this.hints.remove(hint);
        } else {
            this.hints.put(hint, value);
        }
        return this.self();
    }

    @Override
    public final <V> @Nullable V hint(RepresentationHint<V> hint) {
        Object value = this.hints.get(hint);
        if (value != null) {
            return (V)value;
        }
        @Nullable A parent = this.parent;
        if (parent != null && hint.inheritable()) {
            return ((AbstractConfigurationNode)parent).hint(hint);
        }
        return hint.defaultValue();
    }

    @Override
    public final <V> @Nullable V ownHint(RepresentationHint<V> hint) {
        return (V)this.hints.get(hint);
    }

    @Override
    public final Map<RepresentationHint<?>, ?> ownHints() {
        return UnmodifiableCollections.copyOf(this.hints);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractConfigurationNode)) {
            return false;
        }
        AbstractConfigurationNode that = (AbstractConfigurationNode)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
    }

    public String toString() {
        return "AbstractConfigurationNode{key=" + this.key + ", value=" + this.value + '}';
    }

    protected abstract A createNode(Object var1);

    protected abstract A implSelf();
}

