/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine;

import dex.autoswitch.config.data.FallbackSelector;
import dex.autoswitch.engine.Action;
import dex.autoswitch.engine.Matcher;
import dex.autoswitch.engine.Selector;
import dex.autoswitch.engine.data.Match;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.data.extensible.PlayerInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

public class SelectionEngine {
    private final Map<Action, Map<Selector, Set<Selector>>> configuration;
    private final FallbackSelector fallback;

    public SelectionEngine(Map<Action, Map<Selector, Set<Selector>>> configuration, FallbackSelector fallback) {
        this.configuration = Collections.unmodifiableMap(configuration);
        this.fallback = fallback;
    }

    public void select(PlayerInventory<?> inventory, Action action, Object target) {
        this.findSlot(inventory, action, target).ifPresent(inventory::selectSlot);
    }

    public OptionalInt findSlot(PlayerInventory<?> inventory, Action action, Object target) {
        return this.findIdealSlot(inventory, this.configuration.get((Object)action), new SelectionContext(action, target));
    }

    private OptionalInt findIdealSlot(PlayerInventory<?> inventory, Map<Selector, Set<Selector>> selectors, SelectionContext context) {
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (Map.Entry<Selector, Set<Selector>> e : selectors.entrySet()) {
            Selector tgtSel = e.getKey();
            Match targetMatch = tgtSel.matches(context, context.target());
            if (!targetMatch.matches()) continue;
            for (Selector toolSel : e.getValue()) {
                for (int slot = 0; slot < inventory.slotCount(); ++slot) {
                    Match toolMatch = toolSel.matches(context, inventory.getTool(slot));
                    if (!toolMatch.matches()) continue;
                    candidates.add(new Candidate(tgtSel.matcher(), toolSel.matcher(), tgtSel.priority(), targetMatch, toolSel.priority(), toolMatch, slot, slot == inventory.currentSelectedSlot()));
                }
            }
        }
        if (candidates.isEmpty()) {
            return this.pickFallbackSlot(inventory, context);
        }
        Optional<Candidate> best = candidates.stream().max(new ToolOrder(inventory.currentSelectedSlot()));
        return best.map(candidate -> OptionalInt.of(candidate.slot)).orElseGet(OptionalInt::empty);
    }

    private OptionalInt pickFallbackSlot(PlayerInventory<?> inventory, SelectionContext context) {
        if (this.fallback.match(context.action())) {
            Match toolMatch;
            int slot = inventory.currentSelectedSlot();
            while (!(toolMatch = this.fallback.fallback().matches(context, inventory.getTool(slot))).matches()) {
                ++slot;
                if ((slot %= inventory.slotCount()) != inventory.currentSelectedSlot()) continue;
            }
            if (toolMatch.matches()) {
                return OptionalInt.of(slot);
            }
        }
        return OptionalInt.empty();
    }

    private record Candidate(Matcher tar, Matcher tool, int targetPriority, Match targetMatch, int toolPriority, Match toolMatch, int slot, boolean isSelected) {
    }

    private record ToolOrder(int currentSlot) implements Comparator<Candidate>
    {
        @Override
        public int compare(Candidate c1, Candidate c2) {
            int diff = Integer.compare(c1.targetPriority, c2.targetPriority);
            if (diff != 0) {
                return diff;
            }
            int maxTargetRatingLevel = Math.max(c1.targetMatch().getMaxLevel(), c2.targetMatch.getMaxLevel());
            for (int i = 0; i <= maxTargetRatingLevel; ++i) {
                double r2;
                double r1 = c1.targetMatch.getRating(i);
                diff = Double.compare(r1, r2 = c2.targetMatch.getRating(i));
                if (diff == 0) continue;
                return diff;
            }
            diff = Integer.compare(c1.toolPriority, c2.toolPriority);
            if (diff != 0) {
                return diff;
            }
            int maxToolRatingLevel = Math.max(c1.toolMatch().getMaxLevel(), c2.toolMatch.getMaxLevel());
            for (int i = 0; i <= maxToolRatingLevel; ++i) {
                double r2;
                double r1 = c1.toolMatch.getRating(i);
                diff = Double.compare(r1, r2 = c2.toolMatch.getRating(i));
                if (diff == 0) continue;
                return diff;
            }
            diff = Boolean.compare(c1.isSelected, c2.isSelected);
            if (diff != 0) {
                return diff;
            }
            return Integer.compare(c2.slot(), c1.slot());
        }
    }
}

