/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.types.data;

import dex.autoswitch.config.data.tree.Data;
import dex.autoswitch.config.data.tree.DataMap;
import dex.autoswitch.engine.data.Match;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.data.extensible.DataType;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStateData
extends DataType<DataMap> {
    public static final BlockStateData INSTANCE = new BlockStateData();

    private BlockStateData() {
        super("blockstates", DataMap.class);
    }

    @Override
    public Match matches(int baseLevel, SelectionContext context, Object selectable, Data data) {
        if (selectable instanceof BlockState) {
            BlockState blockState = (BlockState)selectable;
            if (data instanceof DataMap) {
                DataMap dataMap = (DataMap)data;
                Set<StateProperty> requiredState = this.process(dataMap);
                StateDefinition stateDefinition = blockState.getBlock().getStateDefinition();
                for (StateProperty stateProperty : requiredState) {
                    Property property = stateDefinition.getProperty(stateProperty.key);
                    if (property == null) {
                        return new Match(false);
                    }
                    Optional expectedValue = property.getValue(stateProperty.val);
                    if (expectedValue.isEmpty()) {
                        return new Match(false);
                    }
                    if (expectedValue.get() == blockState.getValue(property)) continue;
                    return new Match(false);
                }
                return new Match(true);
            }
        }
        return new Match(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<StateProperty> process(DataMap dataMap) {
        HashSet<StateProperty> properties = new HashSet<StateProperty>();
        DataMap dataMap2 = dataMap;
        Objects.requireNonNull(dataMap2);
        DataMap dataMap3 = dataMap2;
        int n = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataMap.Map.class, DataMap.Pair.class, DataMap.Value.class, DataMap.Pair.class}, (Object)dataMap3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DataMap.Map map = (DataMap.Map)dataMap3;
                    Object pair = map.entries().iterator();
                    while (pair.hasNext()) {
                        DataMap dataMap4 = (DataMap)pair.next();
                        properties.addAll(this.process(dataMap4));
                    }
                    return properties;
                }
                case 1: {
                    String string;
                    Object object;
                    Object pair = (DataMap.Pair)dataMap3;
                    try {
                        object = ((DataMap.Pair)pair).key();
                        string = object;
                        object = ((DataMap.Pair)pair).value();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (object instanceof DataMap.Value) {
                        DataMap.Value mv = (DataMap.Value)object;
                        properties.add(new StateProperty(string, mv.value()));
                        return properties;
                    }
                    n = 2;
                    continue block8;
                }
                case 2: {
                    DataMap.Value value = (DataMap.Value)dataMap3;
                    return properties;
                }
                case 3: 
            }
            break;
        }
        DataMap.Pair pair = (DataMap.Pair)dataMap3;
        return properties;
    }

    private record StateProperty(String key, String val) {
    }
}

