/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.gui.debug;

import dex.autoswitch.mixin.mixins.DebugScreenEntriesAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.debug.DebugScreenDisplayer;
import net.minecraft.client.gui.components.debug.DebugScreenEntry;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public class DebugText {
    public static void register() {
        DebugScreenEntriesAccessor.callRegister(ResourceLocation.fromNamespaceAndPath((String)"autoswitch", (String)"enchantments"), new EnchantmentHelp());
        DebugScreenEntriesAccessor.callRegister(ResourceLocation.fromNamespaceAndPath((String)"autoswitch", (String)"item_components"), new ItemComponentHelp());
    }

    private record EnchantmentHelp() implements DebugScreenEntry
    {
        private static final ResourceLocation GROUP_ONE = ResourceLocation.fromNamespaceAndPath((String)"autoswitch", (String)"enchantment_help_one");

        public void display(DebugScreenDisplayer displayer, @Nullable Level level, @Nullable LevelChunk levelChunk, @Nullable LevelChunk levelChunk1) {
            if (level == null || Minecraft.getInstance().player == null) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            ItemStack heldItem = player.getMainHandItem();
            if (heldItem.isEnchanted()) {
                displayer.addToGroup(GROUP_ONE, "Held Item Enchantments:");
                ItemEnchantments enchantments = heldItem.getEnchantments();
                for (Holder enchantment : enchantments.keySet()) {
                    displayer.addToGroup(GROUP_ONE, enchantment.getRegisteredName());
                }
            }
        }
    }

    private record ItemComponentHelp() implements DebugScreenEntry
    {
        private static final ResourceLocation GROUP_ONE = ResourceLocation.fromNamespaceAndPath((String)"autoswitch", (String)"component_help_one");

        public void display(DebugScreenDisplayer displayer, @Nullable Level level, @Nullable LevelChunk levelChunk, @Nullable LevelChunk levelChunk1) {
            if (level == null || Minecraft.getInstance().player == null) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            ItemStack heldItem = player.getMainHandItem();
            DataComponentMap components = heldItem.getComponents();
            if (components.has(DataComponents.POTION_CONTENTS)) {
                displayer.addToGroup(GROUP_ONE, "Held Item Potion Contents:");
                TypedDataComponent pc = components.getTyped(DataComponents.POTION_CONTENTS);
                if (pc == null) {
                    return;
                }
                displayer.addToGroup(GROUP_ONE, ((PotionContents)pc.value()).potion().map(Holder::getRegisteredName).orElse("unknown"));
            }
        }
    }
}

