/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.config.codecs;

import dex.autoswitch.config.data.tree.DataMap;
import dex.lib.org.spongepowered.configurate.ConfigurationNode;
import dex.lib.org.spongepowered.configurate.serialize.SerializationException;
import dex.lib.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public final class DataMapCodec
implements TypeSerializer<DataMap> {
    public static final DataMapCodec INSTANCE = new DataMapCodec();

    private DataMapCodec() {
    }

    @Override
    public DataMap deserialize(@NotNull Type type, ConfigurationNode node) throws SerializationException {
        if (node.isMap()) {
            HashSet<DataMap.Pair> entries = new HashSet<DataMap.Pair>();
            for (Map.Entry<Object, ? extends ConfigurationNode> entry : node.childrenMap().entrySet()) {
                Object object = entry.getKey();
                if (object instanceof String) {
                    String key = (String)object;
                    entries.add(new DataMap.Pair(key, ((ConfigurationNode)entry.getValue()).get(DataMap.class)));
                    continue;
                }
                System.out.println("Unknown key type in DataMap" + String.valueOf(entry.getKey()));
            }
            if (entries.size() == 1) {
                Iterator<Map.Entry<Object, ConfigurationNode>> iterator = entries.iterator();
                if (iterator.hasNext()) {
                    Map.Entry<Object, ? extends ConfigurationNode> entry;
                    entry = (DataMap.Pair)((Object)iterator.next());
                    return entry;
                }
            } else {
                return new DataMap.Map(entries);
            }
        }
        if (node.isList()) {
            return new DataMap.Map(Set.copyOf((Collection)Objects.requireNonNull(node.getList(DataMap.class))));
        }
        return new DataMap.Value(node.getString());
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable DataMap dataMap, @NotNull ConfigurationNode node) throws SerializationException {
        if (dataMap == null) {
            node.raw(null);
            return;
        }
        DataMap dataMap2 = dataMap;
        Objects.requireNonNull(dataMap2);
        DataMap dataMap3 = dataMap2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataMap.Map.class, DataMap.Pair.class, DataMap.Value.class}, (Object)dataMap3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Set<? extends DataMap> set;
                DataMap.Map map = (DataMap.Map)dataMap3;
                Set<? extends DataMap> entries = set = map.entries();
                node.set(entries);
                break;
            }
            case 1: {
                DataMap.Pair pair = (DataMap.Pair)dataMap3;
                Object object = pair.key();
                String key = object;
                Object val = object = pair.value();
                node.node(key).set(val);
                break;
            }
            case 2: {
                String val;
                DataMap.Value value = (DataMap.Value)dataMap3;
                try {
                    String string;
                    val = string = value.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                node.set(String.class, val);
                break;
            }
        }
    }

    private ConfigurationNode nonVirtualNode(ConfigurationNode source, Object ... path) throws SerializationException {
        if (!source.hasChild(path)) {
            throw new SerializationException("Required field " + Arrays.toString(path) + " was not present in node");
        }
        return source.node(path);
    }
}

