/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.config.codecs;

import dex.autoswitch.config.ConfigHandler;
import dex.autoswitch.config.codecs.IdSelectorCodec;
import dex.autoswitch.config.data.tree.DisjunctiveUnion;
import dex.autoswitch.config.data.tree.ExpressionTree;
import dex.autoswitch.config.data.tree.IdSelector;
import dex.autoswitch.config.data.tree.Intersection;
import dex.autoswitch.config.data.tree.Invert;
import dex.autoswitch.config.data.tree.Union;
import dex.lib.io.leangen.geantyref.TypeToken;
import dex.lib.org.spongepowered.configurate.ConfigurationNode;
import dex.lib.org.spongepowered.configurate.serialize.SerializationException;
import dex.lib.org.spongepowered.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class ExpressionTreeCodec
implements TypeSerializer<ExpressionTree> {
    public static final ExpressionTreeCodec INSTANCE = new ExpressionTreeCodec();
    private static final String TYPE = "type";
    private static final String CHILD = "child";
    private static final TypeToken<Set<ExpressionTree>> EXPRESSION_SET = new TypeToken<Set<ExpressionTree>>(){};

    private ExpressionTreeCodec() {
    }

    @Override
    public ExpressionTree deserialize(@NotNull Type type, ConfigurationNode node) throws SerializationException {
        if (node.hasChild(CHILD)) {
            ConfigurationNode typeNode = node.node(TYPE);
            ConfigurationNode childrenNode = node.node(CHILD);
            if (typeNode.virtual()) {
                ConfigHandler.LOGGER.warning(ExpressionTreeCodec.createLogMessage(node, "Failed to find type"));
                return null;
            }
            if (childrenNode.virtual()) {
                ConfigHandler.LOGGER.warning(ExpressionTreeCodec.createLogMessage(node, "Failed to find children"));
                return null;
            }
            OpType op = typeNode.get(OpType.class, OpType.AND);
            Set<ExpressionTree> children = childrenNode.get(EXPRESSION_SET);
            if (children == null) {
                ConfigHandler.LOGGER.warning(ExpressionTreeCodec.createLogMessage(node, "Failed to read children"));
                return null;
            }
            children.removeIf(Objects::isNull);
            OpType opType = op;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"XOR", "AND", "NOT", "OR"}, (OpType)opType, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> new DisjunctiveUnion(children);
                case 1 -> new Union(children);
                case 2 -> {
                    Iterator<ExpressionTree> var9_9;
                    if (children.size() == 1 && (var9_9 = children.iterator()).hasNext()) {
                        ExpressionTree child = var9_9.next();
                        if (child == null) {
                            yield null;
                        }
                        yield new Invert(child);
                    }
                    ConfigHandler.LOGGER.warning(ExpressionTreeCodec.createLogMessage(node, "Inversions cannot have more than one child"));
                    yield null;
                }
                case 3 -> new Intersection(children);
                case -1 -> throw new SerializationException("Could not find operator");
            };
        }
        return IdSelectorCodec.INSTANCE.deserialize(type, node);
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable ExpressionTree obj, @NotNull ConfigurationNode node) throws SerializationException {
        ExpressionTree expressionTree = obj;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DisjunctiveUnion.class, IdSelector.class, Intersection.class, Invert.class, Union.class}, (Object)expressionTree, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                DisjunctiveUnion disjunctiveUnion = (DisjunctiveUnion)expressionTree;
                node.node(TYPE).set((Object)OpType.XOR);
                node.node(CHILD).set(disjunctiveUnion.children());
                break;
            }
            case 1: {
                IdSelector idSelector = (IdSelector)expressionTree;
                node.set(idSelector);
                break;
            }
            case 2: {
                Intersection intersection = (Intersection)expressionTree;
                node.node(TYPE).set((Object)OpType.OR);
                node.node(CHILD).set(intersection.children());
                break;
            }
            case 3: {
                Invert invert = (Invert)expressionTree;
                node.node(TYPE).set((Object)OpType.NOT);
                node.node(CHILD).set(invert.child());
                break;
            }
            case 4: {
                Union union = (Union)expressionTree;
                node.node(TYPE).set((Object)OpType.AND);
                node.node(CHILD).set(union.children());
                break;
            }
            case -1: {
                node.raw(null);
            }
        }
    }

    private static String createLogMessage(ConfigurationNode node, String message) {
        return "Error reading config at: " + String.valueOf(node.path()) + "\nError: " + message;
    }

    private ConfigurationNode nonVirtualNode(ConfigurationNode source, Object ... path) throws SerializationException {
        if (!source.hasChild(path)) {
            throw new SerializationException("Required field " + Arrays.toString(path) + " was not present in node");
        }
        return source.node(path);
    }

    private static enum OpType {
        XOR,
        AND,
        NOT,
        OR;

    }
}

