/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.events;

import dex.autoswitch.config.subentries.FeatureConfig;
import dex.autoswitch.engine.data.Match;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.data.SwitchRegistry;
import dex.autoswitch.engine.data.extensible.SelectableType;
import dex.autoswitch.engine.state.SwitchContext;

public enum SwitchEvent {
    ATTACK{

        @Override
        public boolean perform(SwitchContext ctx) {
            this.handlePrevSlot(ctx);
            ctx.findSlot().ifPresent(switched -> this.handlePostAttack(ctx, (boolean)switched));
            return true;
        }

        private void handlePostAttack(SwitchContext ctx, boolean switched) {
            if (!switched) {
                return;
            }
            SelectableType<?, ?, ?> type = SwitchRegistry.INSTANCE.getSelectableType(ctx.target());
            if (type != null && ctx.config().featureConfig.switchBackAllowed.contains((Object)type.targetType())) {
                this.scheduleSwitchback(ctx);
            }
        }
    }
    ,
    INTERACT{

        @Override
        public boolean perform(SwitchContext ctx) {
            this.handlePrevSlot(ctx);
            ctx.findSlot().ifPresent(switched -> this.handlePostUse(ctx, (boolean)switched));
            return true;
        }

        private void handlePostUse(SwitchContext ctx, boolean switched) {
            if (switched) {
                this.scheduleOffhand(ctx, 0);
                this.scheduleSwitchback(ctx);
            }
        }
    }
    ,
    OFFHAND{

        @Override
        public boolean perform(SwitchContext ctx) {
            for (FeatureConfig.OffhandSelector selector : ctx.config().featureConfig.offhandSelectors) {
                Object tool;
                SelectionContext c;
                Match m;
                if (selector.type != ctx.target() || selector.tool == null || !(m = selector.tool.matches(0, c = new SelectionContext(ctx.action(), ctx.target()), tool = ctx.player().getTool(ctx.player().currentSelectedSlot()))).matches()) continue;
                ctx.player().moveOffhand();
                return true;
            }
            return true;
        }
    }
    ,
    SWITCHBACK{

        @Override
        public boolean perform(SwitchContext ctx) {
            if (this.disallowSwitchback(ctx)) {
                return false;
            }
            if (ctx.switchSlot(ctx.switchState().getPrevSlot())) {
                this.handlePostSwitchback(ctx);
                return true;
            }
            return false;
        }

        private boolean disallowSwitchback(SwitchContext ctx) {
            if (!ctx.player().canSwitchBack(ctx)) {
                return true;
            }
            if (ctx.switchState().preventBlockAttack()) {
                return true;
            }
            if (!ctx.switchState().awaitingSwitchback()) {
                return true;
            }
            SelectableType<?, ?, ?> type = SwitchRegistry.INSTANCE.getSelectableType(ctx.target());
            if (type != null) {
                return !ctx.config().featureConfig.switchBackAllowed.contains((Object)type.targetType());
            }
            return false;
        }

        private void handlePostSwitchback(SwitchContext ctx) {
            ctx.switchState().setAwaitingSwitchback(false);
        }
    }
    ,
    PREVENT_BLOCK_ATTACK{

        @Override
        public boolean perform(SwitchContext ctx) {
            int delay = ctx.config().featureConfig.preventBlockSwitchAfterEntityAttack;
            if (delay <= 0) {
                return true;
            }
            ctx.switchState().setPreventBlockAttack(true);
            ctx.scheduler().schedule(REMOVE_PREVENTION, ctx, delay);
            return true;
        }
    }
    ,
    REMOVE_PREVENTION{

        @Override
        public boolean perform(SwitchContext ctx) {
            ctx.switchState().setPreventBlockAttack(false);
            return true;
        }
    }
    ,
    STAT_CHANGE{

        @Override
        public boolean perform(SwitchContext ctx) {
            this.handlePrevSlot(ctx);
            ctx.findSlot().ifPresent(switched -> this.handlePostEvent(ctx, (boolean)switched));
            return true;
        }

        private void handlePostEvent(SwitchContext ctx, boolean switched) {
            ctx.switchState().setDoOffhandSwitch(true);
            if (switched) {
                this.scheduleOffhand(ctx, 20);
                this.scheduleSwitchback(ctx);
            }
        }
    };


    public abstract boolean perform(SwitchContext var1);

    protected void handlePrevSlot(SwitchContext ctx) {
        ctx.switchState().setPrevSlot(ctx.player().currentSelectedSlot());
    }

    protected void scheduleSwitchback(SwitchContext ctx) {
        ctx.scheduler().schedule(SWITCHBACK, ctx, ctx.config().featureConfig.switchbackDelay);
    }

    protected void scheduleOffhand(SwitchContext ctx, int delayTicks) {
        SelectableType<?, ?, ?> type = SwitchRegistry.INSTANCE.getSelectableType(ctx.target());
        if (type != null) {
            ctx.scheduler().schedule(OFFHAND, ctx.withTarget((Object)type.targetType()), delayTicks);
        }
    }
}

