/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.state;

import dex.autoswitch.config.AutoSwitchConfig;
import dex.autoswitch.engine.Action;
import dex.autoswitch.engine.data.extensible.PlayerInventory;
import dex.autoswitch.engine.events.Scheduler;
import dex.autoswitch.engine.state.SwitchState;
import java.util.Optional;
import java.util.OptionalInt;

public record SwitchContext(PlayerInventory<?> player, AutoSwitchConfig config, Action action, Object target, SwitchState switchState, Scheduler scheduler) {
    public Optional<Boolean> findSlot() {
        OptionalInt maybeSlot = this.config.getEngine().findSlot(this.player, this.action, this.target);
        if (maybeSlot.isPresent()) {
            return Optional.of(this.switchSlot(maybeSlot.getAsInt()));
        }
        return Optional.empty();
    }

    public boolean switchSlot(int slot) {
        boolean switched = slot != this.player.currentSelectedSlot();
        this.player.selectSlot(slot);
        return switched;
    }

    public SwitchContext withTarget(Object o) {
        return new SwitchContext(this.player, this.config, this.action, o, this.switchState, this.scheduler);
    }
}

