/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.types.data;

import dex.autoswitch.Constants;
import dex.autoswitch.config.data.tree.DataMap;
import dex.autoswitch.engine.data.Match;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.data.extensible.DataType;
import dex.autoswitch.futures.FutureSelectable;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class EnchantmentLevelData
extends DataType<DataMap> {
    public static final EnchantmentLevelData INSTANCE = new EnchantmentLevelData();
    private final Map<DataMap, Set<LevelCondition>> CONDITION_CACHE = new HashMap<DataMap, Set<LevelCondition>>();

    private EnchantmentLevelData() {
        super("level", DataMap.class);
    }

    @Override
    public Match matches(int baseLevel, SelectionContext context, Object selectable, DataMap data) {
        Object object = context.target();
        if (object instanceof FutureSelectable) {
            FutureSelectable enchantmentSelector = (FutureSelectable)object;
            if (selectable instanceof ItemStack) {
                ItemStack stack = (ItemStack)selectable;
                ItemEnchantments enchantmentData = stack.getEnchantments();
                Set enchantments = enchantmentData.keySet();
                for (Holder enchantment : enchantments) {
                    if (!enchantmentSelector.matches(null, enchantment.value())) continue;
                    Set condition = this.CONDITION_CACHE.computeIfAbsent(data, this::process);
                    for (LevelCondition levelCondition : condition) {
                        if (levelCondition.matches(enchantmentData.getLevel(enchantment))) continue;
                        return new Match(false);
                    }
                    return new Match(true);
                }
            }
        }
        return new Match(false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<LevelCondition> process(DataMap dataMap) {
        HashSet<LevelCondition> properties = new HashSet<LevelCondition>();
        DataMap dataMap2 = dataMap;
        Objects.requireNonNull(dataMap2);
        DataMap dataMap3 = dataMap2;
        int n = 0;
        block12: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataMap.Map.class, DataMap.Pair.class, DataMap.Value.class, DataMap.Pair.class}, (Object)dataMap3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DataMap.Map map = (DataMap.Map)dataMap3;
                    Object pair = map.entries().iterator();
                    while (pair.hasNext()) {
                        DataMap dataMap4 = (DataMap)pair.next();
                        properties.addAll(this.process(dataMap4));
                    }
                    return properties;
                }
                case 1: {
                    LevelComparison comp;
                    Object val;
                    Object object2;
                    Object object;
                    Object pair = (DataMap.Pair)dataMap3;
                    try {
                        object2 = object = ((DataMap.Pair)pair).key();
                        object = ((DataMap.Pair)pair).value();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (object instanceof DataMap.Value) {
                        DataMap.Value value = (DataMap.Value)object;
                        {
                            val = object = value.value();
                        }
                    } else {
                        n = 2;
                        continue block12;
                    }
                    try {
                        comp = LevelComparison.valueOf(((String)object2).toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException e) {
                        Constants.LOG.error("Unknown comparator: {}", (Object)dataMap);
                        comp = LevelComparison.INVALID;
                    }
                    properties.add(LevelCondition.of(comp, (String)val));
                    return properties;
                }
                case 2: {
                    Object object = (DataMap.Value)dataMap3;
                    {
                        String string;
                        String val = string = ((DataMap.Value)object).value();
                        properties.add(LevelCondition.of(LevelComparison.EQUALS, val));
                    }
                    return properties;
                }
                case 3: 
            }
            break;
        }
        DataMap.Pair pair = (DataMap.Pair)dataMap3;
        return properties;
    }

    private record LevelCondition(LevelComparison comp, Integer level) {
        public static LevelCondition of(LevelComparison comp, String s) {
            int level = 0;
            try {
                level = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                Constants.LOG.error("Could not convert enchantment level to integer {}", (Object)s);
                comp = LevelComparison.INVALID;
            }
            return new LevelCondition(comp, level);
        }

        boolean matches(int level) {
            return switch (this.comp.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> false;
                case 1 -> {
                    if (level == this.level) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (level < this.level) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (level > this.level) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> {
                    if (level <= this.level) {
                        yield true;
                    }
                    yield false;
                }
                case 5 -> level >= this.level;
            };
        }
    }

    private static enum LevelComparison {
        INVALID,
        EQUALS,
        LESSER,
        GREATER,
        LESSER_EQUAL,
        GREATER_EQUAL;

    }
}

