/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.engine.types.selectable;

import dex.autoswitch.engine.TargetType;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.engine.data.extensible.SelectableType;
import dex.autoswitch.futures.FutureSelectable;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import org.jetbrains.annotations.Nullable;

public class StatSelectableType
extends SelectableType<ResourceLocation, Stat<?>, Void> {
    public static final StatSelectableType INSTANCE = new StatSelectableType();

    protected StatSelectableType() {
        super("stat");
    }

    @Override
    public Stat<?> lookup(ResourceLocation resourceLocation) {
        ResourceLocation statType = ResourceLocation.bySeparator((String)resourceLocation.getNamespace(), (char)'.');
        ResourceLocation statName = ResourceLocation.bySeparator((String)resourceLocation.getPath(), (char)'.');
        Optional stat = BuiltInRegistries.STAT_TYPE.getOptional(statType).flatMap(type -> StatSelectableType.getStat(type, statName));
        return stat.orElse(null);
    }

    private static <T> Optional<Stat<?>> getStat(StatType<T> statType, ResourceLocation resourceLocation) {
        return statType.getRegistry().getOptional(resourceLocation).map(arg_0 -> statType.get(arg_0));
    }

    @Override
    public Void lookupGroup(ResourceLocation resourceLocation) {
        return null;
    }

    @Override
    public boolean matches(SelectionContext context, Stat<?> v, Object selectable) {
        if (selectable instanceof Stat) {
            Stat stat = (Stat)selectable;
            return v.equals((Object)stat);
        }
        return false;
    }

    @Override
    public boolean matchesGroup(SelectionContext context, Void statTagKey, Object selectable) {
        return false;
    }

    @Override
    @Nullable
    public TargetType targetType() {
        return TargetType.EVENTS;
    }

    @Override
    public boolean isOf(Object o) {
        return o instanceof Stat;
    }

    @Override
    public double typeRating(SelectionContext context, FutureSelectable<ResourceLocation, Stat<?>> futureValue, Object selectable) {
        return 0.0;
    }

    @Override
    public String serializeKey(ResourceLocation resourceLocation) {
        return resourceLocation.toString();
    }

    @Override
    public ResourceLocation deserializeKey(String key) {
        ResourceLocation id = ResourceLocation.tryParse((String)key);
        if (id != null) {
            return id;
        }
        throw new NullPointerException("Invalid ResourceLocation: " + key);
    }
}

