/*
 * Decompiled with CFR 0.152.
 */
package dex.autoswitch.mixin.mixins;

import dex.autoswitch.Constants;
import dex.autoswitch.config.AutoSwitchConfig;
import dex.autoswitch.engine.Action;
import dex.autoswitch.engine.TargetType;
import dex.autoswitch.engine.data.SelectionContext;
import dex.autoswitch.mixin.impl.SwitchEventTriggerImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StatsCounter.class})
public class MixinStatsCounter {
    @Inject(at={@At(value="HEAD")}, method={"setValue"})
    private void autoswitch$triggerEventSwitchOnStatChange(Player player, Stat<?> stat, int value, CallbackInfo ci) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("autoswitch:eventTrigger");
        if (Minecraft.getInstance().isSingleplayer() && Constants.CONFIG.featureConfig.switchAllowed.contains((Object)TargetType.EVENTS) && Constants.CONFIG.featureConfig.switchActions.contains((Object)Action.STAT_CHANGE) && this.autoswitch$statRelevant(stat)) {
            SwitchEventTriggerImpl.eventTrigger(stat, player);
        }
        profiler.pop();
    }

    @Unique
    private boolean autoswitch$statRelevant(Stat<?> stat) {
        if (Constants.CONFIG.isEventRelevant(stat)) {
            return true;
        }
        for (AutoSwitchConfig.TargetEntry entry : Constants.CONFIG.statChangeAction) {
            if (!entry.target.matches(0, new SelectionContext(Action.STAT_CHANGE, stat), stat).matches()) continue;
            Constants.CONFIG.addEventRelevant(stat);
            return true;
        }
        return false;
    }
}

