/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.attribute.EntityAttribute;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, Boolean booleanValue, Float floatValue, Integer integerValue, String stringValue) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_npc_config_ui", (String)"change_entity_attribute");
    public static final class_8710.class_9154<ChangeEntityAttributeMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, ChangeEntityAttributeMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), ChangeEntityAttributeMessage::create);

    public ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, Boolean value) {
        this(uuid, entityAttribute, value, Float.valueOf(0.0f), 0, "");
    }

    public ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, Float value) {
        this(uuid, entityAttribute, false, value, 0, "");
    }

    public ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, Integer value) {
        this(uuid, entityAttribute, false, Float.valueOf(0.0f), value, "");
    }

    public ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, String value) {
        this(uuid, entityAttribute, false, Float.valueOf(0.0f), 0, value);
    }

    public static ChangeEntityAttributeMessage create(class_2540 buffer) {
        return new ChangeEntityAttributeMessage(buffer.method_10790(), (EntityAttribute)buffer.method_10818(EntityAttribute.class), buffer.readBoolean(), Float.valueOf(buffer.readFloat()), buffer.readInt(), buffer.method_19772());
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.entityAttribute);
        buffer.method_52964(this.booleanValue.booleanValue());
        buffer.method_52941(this.floatValue.floatValue());
        buffer.method_53002(this.integerValue.intValue());
        buffer.method_10814(this.stringValue);
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(class_3222 serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.entityAttribute == null) {
            log.error("Invalid entity attribute for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.booleanValue == null && this.floatValue == null && this.integerValue == null && this.stringValue == null) {
            log.error("Invalid value for {} for {} from {}", (Object)this.entityAttribute, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        boolean successfullyChanged = false;
        if (this.booleanValue != null) {
            successfullyChanged = AttributeHandler.setEntityAttribute((EasyNPC)easyNPC, (EntityAttribute)this.entityAttribute, (boolean)this.booleanValue);
        }
        if (!successfullyChanged) {
            log.error("Unable to change entity attribute {} for {} from {}", (Object)this.entityAttribute, (Object)easyNPC, (Object)serverPlayer);
        }
    }
}

