/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.skin;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.configui.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.EntityRenderOverrides;
import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantDataCapable;
import de.markusbordihn.easynpc.screen.render.EntityScreenRenderer;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.ArrayList;
import net.minecraft.class_1646;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;

public class DefaultSkinConfigurationScreen<T extends ConfigurationMenu>
extends SkinConfigurationScreen<T> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    protected int numOfProfessions = 0;
    protected int numOfVariants = 0;

    public DefaultSkinConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
        this.maxSkinsPerPage = 10;
    }

    private void renderSkins(class_332 guiGraphics) {
        if (this.getEasyNPCEntity() == null) {
            return;
        }
        int skinPosition = 0;
        this.skinButtons = new ArrayList();
        VariantDataCapable variantData = this.getEasyNPC().getEasyNPCVariantData();
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int variantIndex = i;
            if (variantIndex >= variantData.getVariantTypes().length) {
                variantIndex %= variantData.getVariantTypes().length;
            }
            Enum variant = variantData.getVariantTypes()[variantIndex];
            int left = this.leftPos + (skinPosition > 4 ? -268 : 32) + skinPosition * 60;
            int top = this.contentTopPos + 102 + (skinPosition > 4 ? 84 : 0);
            this.renderSkinEntity(guiGraphics, left, top, variant, null);
            int topNamePos = Math.round(((float)top - 76.0f) / 0.7f);
            int leftNamePos = Math.round(((float)left - 21.0f) / 0.7f);
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            guiGraphics.method_51448().method_22905(0.7f, 0.7f, 0.7f);
            String variantName = variant.name();
            if (this.getEasyNPCEntity() instanceof class_1646 && variantName.contains("_") && !variantName.equals("DEFAULT")) {
                String[] parts = variantName.split("_", 2);
                Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)TextUtils.normalizeString((String)parts[0], (int)14), (int)leftNamePos, (int)topNamePos, (int)43520);
                Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)TextUtils.normalizeString((String)parts[1], (int)13), (int)leftNamePos, (int)(topNamePos + 10), (int)0);
            } else {
                Text.drawString((class_332)guiGraphics, (class_327)this.field_22793, (String)TextUtils.normalizeString((String)variantName, (int)14), (int)leftNamePos, (int)topNamePos, (int)43520);
            }
            guiGraphics.method_51448().method_22909();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(class_332 guiGraphics, int x, int y, Enum<?> variantType, Profession profession) {
        SkinSelectionButton skinButton = new SkinSelectionButton(x - 24, y - 81, button -> {
            if (profession != null) {
                NetworkMessageHandlerManager.getServerHandler().changeProfession(this.getEasyNPCUUID(), profession);
            }
            NetworkMessageHandlerManager.getServerHandler().setSkin(this.getEasyNPCUUID(), SkinDataEntry.createDefaultSkin((String)variantType.name()));
        });
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        VariantDataCapable variantData = this.getEasyNPC().getEasyNPCVariantData();
        ProfessionDataCapable professionData = this.getEasyNPC().getEasyNPCProfessionData();
        skinButton.field_22763 = skinData.getSkinType() != SkinType.DEFAULT || !variantData.getVariantType().equals(variantType) || profession != null && !professionData.getProfession().equals((Object)profession);
        EntityScreenRenderer.renderEntity((class_332)guiGraphics, (EasyNPC)this.getEasyNPC(), (EntityRenderConfig)EntityRenderConfig.withOverrides((int)(x + 4), (int)(y + 7), (int)30, (float)((float)x - this.xMouse), (float)((float)(y - 40) - this.yMouse), (EntityRenderOverrides)EntityRenderOverrides.withVariant(variantType, (Profession)profession)), (float)this.xMouse, (float)this.yMouse);
        this.skinButtons.add(skinButton);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.defaultSkinButton.field_22763 = false;
        this.setDescriptionText("default_skin.text");
        VariantDataCapable variantData = this.getEasyNPC().getEasyNPCVariantData();
        ProfessionDataCapable professionData = this.getEasyNPC().getEasyNPCProfessionData();
        this.numOfProfessions = professionData.hasProfessions() ? professionData.getProfessions().length : 0;
        this.numOfSkins = this.numOfVariants = variantData.getVariantTypes().length;
        log.debug("Found {} predefined variant combinations.", (Object)this.numOfSkins);
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        this.method_37063((class_364)new Checkbox(this.contentLeftPos + 55, this.contentTopPos + 192, "disable_skin_layers", skinData.getSkinDataEntry().disableLayers(), checkbox -> NetworkMessageHandlerManager.getServerHandler().setSkin(this.getEasyNPCUUID(), skinData.getSkinDataEntry().withDisableLayers(checkbox.selected()))));
        this.defineSkinNavigationButtons();
    }

    @Override
    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        this.renderDescriptionText(guiGraphics, this.contentLeftPos + 5, this.contentTopPos + 5);
        this.renderSkins(guiGraphics);
    }

    @Override
    protected void renderSkinSelectionBackground(class_332 guiGraphics) {
        guiGraphics.method_25294(this.contentLeftPos, this.contentTopPos + 20, this.contentLeftPos + 302, this.contentTopPos + 190, -16777216);
        guiGraphics.method_25294(this.contentLeftPos + 1, this.contentTopPos + 21, this.contentLeftPos + 301, this.contentTopPos + 189, -5592406);
    }
}

