/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.preset.PresetType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.PresetHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public record ImportPresetMessage(UUID uuid, PresetType presetType, CompoundTag compoundTag, ResourceLocation resourceLocation) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"import_preset");
    public static final CustomPacketPayload.Type<ImportPresetMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ImportPresetMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ImportPresetMessage::create);

    public static ImportPresetMessage create(FriendlyByteBuf buffer) {
        return new ImportPresetMessage(buffer.readUUID(), (PresetType)buffer.readEnum(PresetType.class), buffer.readNbt(), buffer.readResourceLocation());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeEnum((Enum)this.presetType);
        buffer.writeNbt((Tag)this.compoundTag);
        buffer.writeResourceLocation(this.resourceLocation);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        switch (this.presetType) {
            case LOCAL: {
                PresetHandler.importLocalPreset((ServerLevel)serverPlayer.serverLevel(), (CompoundTag)this.compoundTag, (ResourceLocation)this.resourceLocation, (Vec3)easyNPC.getEntity().position(), (UUID)this.uuid, null);
                break;
            }
            case CUSTOM: {
                PresetHandler.importCustomPreset((ServerLevel)serverPlayer.serverLevel(), (ResourceLocation)this.resourceLocation, (Vec3)easyNPC.getEntity().position(), (UUID)this.uuid, null);
                break;
            }
            case DATA: {
                PresetHandler.importDataPreset((ServerLevel)serverPlayer.serverLevel(), (ResourceLocation)this.resourceLocation, (Vec3)easyNPC.getEntity().position(), (UUID)this.uuid, null);
                break;
            }
            case DEFAULT: {
                PresetHandler.importDefaultPreset((ServerLevel)serverPlayer.serverLevel(), (ResourceLocation)this.resourceLocation, (Vec3)easyNPC.getEntity().position(), (UUID)this.uuid, null);
                break;
            }
            case WORLD: {
                PresetHandler.importWorldPreset((ServerLevel)serverPlayer.serverLevel(), (ResourceLocation)this.resourceLocation, (Vec3)easyNPC.getEntity().position(), (UUID)this.uuid, null);
                break;
            }
            default: {
                log.error("Invalid preset type {} from {}", (Object)this.presetType, (Object)serverPlayer);
            }
        }
    }
}

