/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.configui.debug.DebugManager;
import de.markusbordihn.easynpc.configui.item.ModItems;
import de.markusbordihn.easynpc.configui.menu.MenuHandler;
import de.markusbordihn.easynpc.configui.menu.MenuManager;
import de.markusbordihn.easynpc.configui.menu.ModMenuTypes;
import de.markusbordihn.easynpc.configui.network.ClientNetworkMessageHandler;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import java.util.Optional;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="easy_npc_config_ui")
public class ConfigUIMain {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Config UI");

    public ConfigUIMain(FMLJavaModLoadingContext context) {
        BusGroup modBusGroup = context.getModBusGroup();
        log.info("Initializing {} (Forge) ...", (Object)"Easy NPC: Config UI");
        log.info("{} Debug Manager ...", (Object)"\ud83d\udde3 Register Easy NPC: Config UI");
        Optional version = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.VERSION.get());
        if (version.isPresent() && "MOD_DEV".equals(version.get())) {
            DebugManager.setDevelopmentEnvironment(true);
        }
        DebugManager.checkForDebugLogging("Easy NPC: Config UI");
        log.info("{} Constants ...", (Object)"\ud83d\udde3 Register Easy NPC: Config UI");
        Constants.GAME_DIR = FMLPaths.GAMEDIR.get();
        Constants.CONFIG_DIR = FMLPaths.CONFIGDIR.get();
        log.info("{} Items ...", (Object)"\ud83d\udde3 Register Easy NPC: Config UI");
        ModItems.ITEMS.register(modBusGroup);
        log.info("{} Menu Types ...", (Object)"\ud83d\udde3 Register Easy NPC: Config UI");
        ModMenuTypes.MENU_TYPES.register(modBusGroup);
        log.info("{} Menu Handler ...", (Object)"\ud83d\udde3 Register Easy NPC: Config UI");
        MenuManager.registerMenuHandler(new MenuHandler());
        log.info("{} Network Handler ...", (Object)"\ud83d\udde3 Register Easy NPC: Config UI");
        NetworkMessageHandlerManager.registerClientHandler(new ClientNetworkMessageHandler());
    }
}

